/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.ext.lb.LoadBalancer;
import com.sun.appserv.management.helper.LBConfigHelper;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.cli.commands.BaseHttpLBCommand;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServerConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateHttpLBCommand
extends BaseHttpLBCommand {
    private static final String TARGET_OPTION = "target";
    private static final String CONFIG_OPTION = "config";
    private static final String AUTO_APPLY_ENABLED_OPTION = "autoapplyenabled";
    private static final String DEVICE_HOST_OPTION = "devicehost";
    private static final String DEVICE_PORT_OPTION = "deviceport";
    private static final String SSL_PROXY_HOST_OPTION = "sslproxyhost";
    private static final String SSL_PROXY_PORT_OPTION = "sslproxyport";
    private static final String PROPERTY_OPTION = "property";
    private static final StringManager _strMgr = StringManager.getManager(CreateHttpLBCommand.class);

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        String lbName = (String)this.getOperands().get(0);
        boolean autoApplyEnabled = this.getBooleanOption(AUTO_APPLY_ENABLED_OPTION);
        Map instanceWeights = this.getInstanceWeightsMap();
        String target = this.getOption(TARGET_OPTION);
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            LBConfigHelper lbconfigHelper = new LBConfigHelper(domainRoot);
            lbconfigHelper.createLoadBalancer(lbName, target, this.getLBParams(), this.getLBProperties());
            boolean isCluster = domainRoot.getDomainConfig().getClusterConfigMap().keySet().contains(target);
            if (!isCluster) {
                _strMgr.getString("WeightCannotApplyToNonCluster", new Object[]{target});
            } else if (this.getOption("lbweight") != null) {
                lbconfigHelper.configureLBWeight(target, instanceWeights);
            }
            if (autoApplyEnabled && !((LoadBalancer)domainRoot.getLoadBalancerMap().get(lbName)).testConnection()) {
                CLILogger.getInstance().printWarning(_strMgr.getString("CouldNotPingLB", new Object[]{lbName}));
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    private Map<String, String> getLBProperties() throws Exception {
        Properties props;
        String sslHost = this.getOption(SSL_PROXY_HOST_OPTION);
        String sslPort = this.getOption(SSL_PROXY_PORT_OPTION);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("property.device-host", this.getOption(DEVICE_HOST_OPTION));
        String devicePort = this.getOption(DEVICE_PORT_OPTION);
        this.validatePort(devicePort);
        properties.put("property.device-admin-port", devicePort);
        if (sslHost != null) {
            properties.put("property.ssl-proxy-host", sslHost);
        }
        if (sslPort != null) {
            this.validatePort(sslPort);
            properties.put("property.ssl-proxy-port", sslPort);
        }
        if ((props = this.createPropertiesParam(this.getOption(PROPERTY_OPTION))) != null) {
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = props.getProperty(name);
                properties.put("property." + name, value);
                CLILogger.getInstance().printDebugMessage("Property name=" + name + ", value=" + value);
            }
        }
        return properties;
    }

    private Map<String, String> getLBParams() {
        HashMap<String, String> mLBOptions = new HashMap<String, String>();
        this.addToOptions(mLBOptions, "httpsrouting");
        this.addToOptions(mLBOptions, "responsetimeout");
        this.addToOptions(mLBOptions, "reloadinterval");
        this.addToOptions(mLBOptions, "monitor");
        this.addToOptions(mLBOptions, "routecookie");
        this.addToOptions(mLBOptions, "healthcheckerurl");
        this.addToOptions(mLBOptions, "healthcheckerinterval");
        this.addToOptions(mLBOptions, "healthcheckertimeout");
        this.addToOptions(mLBOptions, AUTO_APPLY_ENABLED_OPTION);
        this.addToOptions(mLBOptions, "lbenableallinstances");
        this.addToOptions(mLBOptions, "lbenableallapplications");
        this.addToOptions(mLBOptions, "lbpolicy");
        this.addToOptions(mLBOptions, "lbpolicymodule");
        return mLBOptions;
    }
}

