/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.jbi.ui.client.JBIAdminCommandsClientFactory;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServerConnection;

public abstract class JBICommand
extends S1ASCommand {
    protected static final String VERBOSE = "verbose";
    protected static final String TERSE = "terse";
    protected static final String TARGET_OPTION = "target";
    protected static final String LIBRARY_NAME_OPTION = "libraryname";
    protected static final String ASSEMBLY_NAME_OPTION = "assemblyname";
    protected static final String COMPONENT_NAME_OPTION = "componentname";
    protected static final String UPLOAD_OPTION = "upload";
    protected static final String ENABLED_OPTION = "enabled";
    protected static final String LIFECYCLE_STATE_OPTION = "lifecyclestate";
    protected static final String FORCE_OPTION = "force";
    protected static final String KEEP_ARCHIVE_OPTION = "keeparchive";
    protected static final String COMPONENT_PROPERTIES = "properties";
    static String[] validStates = new String[]{"started", "stopped", "shutdown"};
    JBIAdminCommands mJbiAdminCommands = null;
    MBeanServerConnection mbsc = null;

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    protected String getOption(String optionName, String[] validOptions, String defaultValue) throws CommandValidationException {
        boolean found = false;
        String option = this.getOption(optionName);
        if (option == null) {
            option = defaultValue;
            found = true;
        } else {
            for (int i = 0; i < validOptions.length; ++i) {
                if (!option.equalsIgnoreCase(validOptions[i])) continue;
                found = true;
                break;
            }
        }
        if (found) {
            return option;
        }
        throw new CommandValidationException(this.getLocalizedString("InvalidValueInOption", new Object[]{optionName}));
    }

    protected String getOption(String optionName, String[] validOptions) throws CommandValidationException {
        String defaultValue = null;
        return this.getOption(optionName, validOptions, defaultValue);
    }

    protected String validateFilePath(String filePath) throws CommandException {
        return this.validateFilePath("FileDoesNotExist", filePath);
    }

    protected String validateFilePath(String errorKey, String filePath) throws CommandException {
        File file = new File(filePath);
        String absolutePath = file.getAbsolutePath();
        if (!file.exists() || file.isDirectory()) {
            throw new CommandException(this.getLocalizedString(errorKey, new Object[]{filePath}));
        }
        return absolutePath;
    }

    protected boolean preRunInit() throws CommandValidationException, CommandException, JBIRemoteException {
        boolean uploadFlag = false;
        return this.preRunInit(uploadFlag);
    }

    protected boolean preRunInit(boolean uploadFlag) throws CommandValidationException, CommandException, JBIRemoteException {
        this.validateOptions();
        this.mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        try {
            this.mJbiAdminCommands = JBIAdminCommandsClientFactory.getInstance((MBeanServerConnection)this.mbsc, (boolean)uploadFlag);
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
        if (this.mJbiAdminCommands == null) {
            throw new CommandException(this.getLocalizedString("CouldNotInvokeCommand", new Object[]{this.name}));
        }
        return true;
    }

    protected void processJBIAdminComponentListResult(String result) {
        List list = JBIComponentInfo.readFromXmlText((String)result);
        if (list.size() == 0) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList", new Object[]{result}));
        } else {
            Iterator it = list.iterator();
            String listBreak = "";
            boolean count = false;
            while (it.hasNext()) {
                JBIComponentInfo info = (JBIComponentInfo)it.next();
                String componentName = info.getName();
                CLILogger.getInstance().printDetailMessage(componentName);
            }
        }
    }

    protected void processJBIAdminAsseblyListResult(String result) {
        List list = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)result);
        if (list.size() == 0) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList", new Object[]{result}));
        } else {
            Iterator it = list.iterator();
            String listBreak = "";
            boolean count = false;
            while (it.hasNext()) {
                ServiceAssemblyInfo info = (ServiceAssemblyInfo)it.next();
                String assemblyName = info.getName();
                CLILogger.getInstance().printDetailMessage(assemblyName);
            }
        }
    }

    protected void processJBIAdminShowComponentResult(String result, String aName) {
        List list = JBIComponentInfo.readFromXmlText((String)result);
        if (list.size() == 0) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBINoComponentToShow", new Object[]{aName}));
        } else {
            CLILogger.getInstance().printDetailMessage("");
            String header = this.getLocalizedString("JBIComponentShowHeader");
            CLILogger.getInstance().printDetailMessage(header);
            CLILogger.getInstance().printDetailMessage(this.createFillString('-', header.length()));
            Iterator it = list.iterator();
            JBIComponentInfo info = (JBIComponentInfo)it.next();
            String componentName = info.getName();
            String componentState = info.getState();
            String componentDescription = info.getDescription();
            String formattedDescription = this.formatDescription(componentDescription, 50, 14);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBIComponentName", new Object[]{componentName}));
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBIComponentState", new Object[]{componentState}));
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBIComponentDescription", new Object[]{formattedDescription}));
        }
    }

    protected void processJBIAdminShowLibraryResult(String result, String aName) {
        List list = JBIComponentInfo.readFromXmlText((String)result);
        if (list.size() == 0) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBINoLibraryToShow", new Object[]{aName}));
        } else {
            CLILogger.getInstance().printDetailMessage("");
            String header = this.getLocalizedString("JBISharedLibraryShowHeader");
            CLILogger.getInstance().printDetailMessage(header);
            CLILogger.getInstance().printDetailMessage(this.createFillString('-', header.length()));
            Iterator it = list.iterator();
            JBIComponentInfo info = (JBIComponentInfo)it.next();
            String libraryName = info.getName();
            String libraryDescription = info.getDescription();
            String formattedDescription = this.formatDescription(libraryDescription, 50, 14);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBISharedLibraryName", new Object[]{libraryName}));
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBISharedLibraryDescription", new Object[]{formattedDescription}));
        }
    }

    protected void processJBIAdminShowAssemblyResult(String result, String aName) {
        List list = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)result);
        if (list.size() <= 0) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBINoServiceAssemblyToShow", new Object[]{aName}));
        } else {
            Iterator itr = list.iterator();
            ServiceAssemblyInfo saInfo = (ServiceAssemblyInfo)itr.next();
            List suInfoList = saInfo.getServiceUnitInfoList();
            String saName = saInfo.getName();
            String saState = saInfo.getState();
            String saDescription = saInfo.getDescription();
            String saSize = Integer.toString(suInfoList.size());
            String formattedSADescription = this.formatDescription(saDescription, 50, 16);
            CLILogger.getInstance().printDetailMessage("");
            String SAHeader = this.getLocalizedString("JBIServiceAssemblyShowHeader");
            CLILogger.getInstance().printDetailMessage(SAHeader);
            CLILogger.getInstance().printDetailMessage(this.createFillString('-', SAHeader.length()));
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBIServiceAssemblyName", new Object[]{saName}));
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBIServiceAssemblyState", new Object[]{saState}));
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBIServiceAssemblyServiceUnits", new Object[]{saSize}));
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("JBIServiceAssemblyDescription", new Object[]{formattedSADescription}));
            String indentString = "    ";
            CLILogger.getInstance().printDetailMessage("");
            String SUHeader = this.getLocalizedString("JBIServiceUnitShowHeader");
            CLILogger.getInstance().printDetailMessage(indentString + SUHeader);
            CLILogger.getInstance().printDetailMessage(indentString + this.createFillString('-', SUHeader.length()));
            boolean firstTime = true;
            for (ServiceUnitInfo suInfo : suInfoList) {
                String suState = suInfo.getState();
                String suDepoyedOn = suInfo.getDeployedOn();
                String suName = suInfo.getName();
                String suDescription = suInfo.getDescription();
                String formattedSUDescription = this.formatDescription(suDescription, 50, 18);
                if (!firstTime) {
                    CLILogger.getInstance().printDetailMessage("");
                }
                CLILogger.getInstance().printDetailMessage(indentString + this.getLocalizedString("JBIServiceUnitName", new Object[]{suName}));
                CLILogger.getInstance().printDetailMessage(indentString + this.getLocalizedString("JBIServiceUnitState", new Object[]{suState}));
                CLILogger.getInstance().printDetailMessage(indentString + this.getLocalizedString("JBIServiceUnitDeployedOn", new Object[]{suDepoyedOn}));
                CLILogger.getInstance().printDetailMessage(indentString + this.getLocalizedString("JBIServiceUnitDescription", new Object[]{formattedSUDescription}));
                firstTime = false;
            }
        }
    }

    protected void processJBIAdminResult(String result, String successKey) throws CommandException {
        JBIManagementMessage mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)result);
        if (mgmtMsg == null) {
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString(successKey, new Object[]{result}));
        } else if (mgmtMsg.isSuccessMsg()) {
            String msg = mgmtMsg.getMessage();
            int index = msg.indexOf(")");
            if (index != -1) {
                msg = msg.substring(index + 1);
            }
            CLILogger.getInstance().printDetailMessage(msg);
        } else {
            String msg = mgmtMsg.getMessage();
            throw new CommandException(msg);
        }
    }

    protected void processTaskException(Exception ex) throws CommandException {
        JBIManagementMessage mgmtMsg = this.extractJBIManagementMessage(ex);
        if (mgmtMsg == null) {
            this.displayExceptionMessage(ex);
        } else {
            String msg = mgmtMsg.getMessage();
            CLILogger.getInstance().printDetailMessage(msg);
            if (msg.trim().startsWith("WARNING")) {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
            } else {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}));
            }
        }
    }

    protected JBIManagementMessage extractJBIManagementMessage(Exception ex) {
        JBIManagementMessage mgmtMsg = null;
        if (ex instanceof JBIRemoteException) {
            JBIRemoteException rEx = (JBIRemoteException)ex;
            mgmtMsg = rEx.extractJBIManagementMessage();
        } else {
            String exMessage = ex.getMessage();
            mgmtMsg = JBIManagementMessage.createJBIManagementMessage((String)exMessage);
        }
        return mgmtMsg;
    }

    private String createFillString(char fillChar, int size) {
        String fillString = "";
        for (int i = 0; i < size; ++i) {
            fillString = fillString + fillChar;
        }
        return fillString;
    }

    private String formatDescription(String description, int maxLength, int indentAmount) {
        int endIndex = 0;
        int startIndex = 0;
        String finalString = "";
        String rowString = "";
        String space = "";
        endIndex = description.indexOf("\n", startIndex);
        while (endIndex != -1) {
            rowString = description.substring(startIndex, endIndex).trim();
            finalString = finalString + space + rowString;
            startIndex = endIndex + 1;
            endIndex = description.indexOf("\n", startIndex);
            space = " ";
        }
        rowString = description.substring(startIndex).trim();
        finalString = finalString + space + rowString;
        endIndex = 0;
        startIndex = 0;
        int spaceIndex = 0;
        int indentSize = 0;
        String newString = "";
        boolean done = false;
        int totalLength = finalString.length();
        while (!done) {
            endIndex = startIndex + maxLength > totalLength ? totalLength : startIndex + maxLength;
            rowString = finalString.substring(startIndex, endIndex);
            spaceIndex = startIndex + rowString.lastIndexOf(" ");
            if (endIndex < totalLength && (spaceIndex = startIndex + rowString.lastIndexOf(" ")) != -1) {
                endIndex = spaceIndex;
            }
            rowString = finalString.substring(startIndex, endIndex) + "\n";
            startIndex = endIndex + 1;
            newString = newString + this.createFillString(' ', indentSize) + rowString;
            indentSize = indentAmount;
            if (startIndex < totalLength) continue;
            done = true;
        }
        finalString = newString.trim();
        return finalString;
    }

    protected JBIAdminCommands getJBIAdminCommands() {
        return this.mJbiAdminCommands;
    }
}

