/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.JBICommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;

public class JBIUninstallCommands
extends JBICommand {
    private static final String UNINSTALL_COMPONENT = "uninstall-jbi-component";
    private static final String UNINSTALL_SHARED_LIBRARY = "uninstall-jbi-shared-library";
    private static final String UNDEPLOY_SERVICE_ASSEMBLY = "undeploy-jbi-service-assembly";

    public void runCommand() throws CommandException, CommandValidationException {
        String result = "";
        String successKey = "";
        try {
            if (this.preRunInit()) {
                String targetName = this.getOption("target");
                boolean force = this.getBooleanOption("force");
                boolean keepArchive = this.getBooleanOption("keeparchive");
                String componentName = (String)this.getOperands().get(0);
                if (this.name.equals(UNINSTALL_COMPONENT)) {
                    result = this.mJbiAdminCommands.uninstallComponent(componentName, force, keepArchive, targetName);
                    successKey = "JBISuccessUninstallComponent";
                } else if (this.name.equals(UNINSTALL_SHARED_LIBRARY)) {
                    result = this.mJbiAdminCommands.uninstallSharedLibrary(componentName, force, keepArchive, targetName);
                    successKey = "JBISuccessUninstallSharedLibrary";
                } else if (this.name.equals(UNDEPLOY_SERVICE_ASSEMBLY)) {
                    result = this.mJbiAdminCommands.undeployServiceAssembly(componentName, force, keepArchive, targetName);
                    successKey = "JBISuccessUndeployServiceAssembly";
                }
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString(successKey, new Object[]{componentName}));
            }
        }
        catch (Exception e) {
            this.processTaskException(e);
        }
    }
}

