/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class ListMBeansCommand
extends GenericCommand {
    private static final String ENABLED_OPERATION = "isMBeanEnabled";

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException("Validation is false");
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        String objectName = this.getObjectName();
        Object[] params = this.getParamsInfo();
        String operationName = this.getOperationName();
        String[] types = this.getTypesInfo();
        try {
            List returnValue = (List)mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            if (returnValue.size() == 0) {
                CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
            }
            String target = this.getOperands().size() > 0 ? (String)this.getOperands().get(0) : null;
            CLILogger.getInstance().printDebugMessage("target = " + target);
            CLILogger.getInstance().printDebugMessage("list size = " + returnValue.size());
            for (int ii = 0; ii < returnValue.size(); ++ii) {
                ObjectName objName = (ObjectName)returnValue.get(ii);
                CLILogger.getInstance().printDebugMessage("objName = " + objName.toString());
                String mbeanName = (String)mbsc.getAttribute(objName, "name");
                String mbeanObjName = (String)mbsc.getAttribute(objName, "object-name");
                String boolVal = (String)mbsc.getAttribute(objName, "enabled");
                boolean enabled = Boolean.valueOf(boolVal);
                String printString = mbeanName + " " + mbeanObjName + " " + (enabled ? this.getLocalizedString("Enabled") : this.getLocalizedString("Disabled"));
                CLILogger.getInstance().printMessage(printString);
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }
}

