/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CliUtil;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import java.io.IOException;
import javax.management.MBeanServerConnection;

public class LoginCommand
extends S1ASCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String userName = this.getUser();
        String password = this.getPassword();
        String host = this.getHost();
        int port = this.getPort();
        this.authenticate(host, port, userName, password);
        this.saveLogin(host, port, userName, password);
    }

    protected String getUser() throws CommandValidationException {
        try {
            InputsAndOutputs.getInstance().getUserOutput().print(this.getLocalizedString("AdminUserPrompt"));
            return InputsAndOutputs.getInstance().getUserInput().getLine();
        }
        catch (IOException ioe) {
            throw new CommandValidationException(this.getLocalizedString("CannotReadOption", new Object[]{"user"}));
        }
    }

    protected String getPassword() throws CommandValidationException {
        String passwordValue;
        try {
            InputsAndOutputs.getInstance().getUserOutput().print(this.getLocalizedString("AdminPasswordPrompt"));
            passwordValue = new CliUtil().getPassword();
        }
        catch (NoClassDefFoundError e) {
            passwordValue = this.readInput();
        }
        catch (UnsatisfiedLinkError e) {
            passwordValue = this.readInput();
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
        return passwordValue;
    }

    private void authenticate(String host, int port, String user, String password) throws CommandException, CommandValidationException {
        try {
            Object[] params = new Object[]{host, "" + port};
            CLILogger.getInstance().printMessage(this.getLocalizedString("AuthenticatingMsg", params));
            MBeanServerConnection mbsc = super.getMBeanServerConnection(host, port, user, password);
            String dd = mbsc.getDefaultDomain();
            String msg = "Authentication succeeded to: " + host + "and port: " + port;
            CLILogger.getInstance().printDebugMessage(msg);
        }
        catch (IOException ioe) {
            throw new CommandException(ioe);
        }
    }

    private void saveLogin(String host, int port, String user, String password) throws CommandException {
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
            LoginInfo login = new LoginInfo(host, port, user, password);
            String msg = null;
            boolean storeIt = this.handleExists(store, login);
            if (storeIt) {
                store.store(login, true);
                Object[] params = new Object[]{login.getUser(), login.getHost(), "" + login.getPort(), store.getName()};
                msg = this.getLocalizedString("LoginInfoStored", params);
            } else {
                Object[] params = new Object[]{login.getHost(), "" + login.getPort()};
                msg = this.getLocalizedString("LoginInfoNotStored", params);
            }
            CLILogger.getInstance().printMessage(msg);
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }

    private boolean handleExists(LoginInfoStore store, LoginInfo login) throws Exception {
        boolean storeIt = true;
        if (store.exists(login.getHost(), login.getPort())) {
            storeIt = this.promptOnce(login);
        }
        return storeIt;
    }

    private boolean promptOnce(LoginInfo login) throws Exception {
        boolean userPressedYes = false;
        String YES = "y";
        Object[] loginId = new Object[]{login.getHost(), "" + login.getPort()};
        String prompt = this.getLocalizedString("ShouldOverwriteLogin", loginId);
        InputsAndOutputs io = InputsAndOutputs.getInstance();
        io.getUserOutput().print(prompt);
        String in = io.getUserInput().getLine();
        userPressedYes = "y".equalsIgnoreCase(in);
        return userPressedYes;
    }
}

