/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Timer;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JVMStats;

public class JVMMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-25s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s";

    public JVMMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) {
        super(srm, filter, timer, verbose, fileName);
        String jvmTitle = localStrings.getString("commands.monitor.jvm_monitoring_title");
        String title = String.format("%1$45s", jvmTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        JVMStats jvmStats = this.srm.getJVMMonitor().getJVMStats();
        if (jvmStats == null) {
            this.cancelMonitorTask();
            return;
        }
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(jvmStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private void displayData(JVMStats jvmStats) {
        BoundedRangeStatistic heapSize = jvmStats.getHeapSize();
        CountStatistic upTime = jvmStats.getUpTime();
        String data = String.format("%1$-25s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s", upTime.getCount(), heapSize.getLowerBound(), heapSize.getUpperBound(), heapSize.getLowWaterMark(), heapSize.getHighWaterMark(), heapSize.getCurrent());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s", upTime.getCount(), heapSize.getLowerBound(), heapSize.getUpperBound(), heapSize.getLowWaterMark(), heapSize.getHighWaterMark(), heapSize.getCurrent());
            this.writeToFile(fileData);
        }
    }

    private void displayHeader() {
        String upTime = localStrings.getString("commands.monitor.uptime");
        String heapSize = localStrings.getString("commands.monitor.heapsize");
        String current = localStrings.getString("commands.monitor.current");
        String min = localStrings.getString("commands.monitor.min");
        String max = localStrings.getString("commands.monitor.max");
        String low = localStrings.getString("commands.monitor.low");
        String high = localStrings.getString("commands.monitor.high");
        String count = localStrings.getString("commands.monitor.count");
        String header = String.format("%1$-45s %2$-20s", upTime, heapSize);
        String subHeader = String.format("%1$-25s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s", current, min, max, low, high, count);
        CLILogger.getInstance().printMessage(header);
        CLILogger.getInstance().printMessage(subHeader);
        if (this.fileName != null) {
            this.writeToFile(upTime + ":" + current + "," + heapSize + ":" + min + "," + heapSize + ":" + max + "," + heapSize + ":" + low + "," + heapSize + ":" + high + "," + heapSize + ":" + count);
        }
    }

    public void displayDetails() {
    }
}

