/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ApplicationMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.ServletMonitor;
import com.sun.appserv.management.monitor.WebModuleVirtualServerMonitor;
import com.sun.appserv.management.monitor.statistics.AltServletStats;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s %8$-8s";
    private String appName = null;
    private String webName = null;
    private String servletName = null;

    public ServletMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        if (this.filter == null) {
            this.getDefaultFilter();
        } else {
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            if (st.countTokens() < 2) {
                throw new MonitorTaskException(localStrings.getString("commands.monitor.servlet_invalid_filter"));
            }
            if (st.countTokens() == 2) {
                this.webName = st.nextToken();
                this.servletName = st.nextToken();
            } else {
                this.appName = st.nextToken();
                this.webName = st.nextToken();
                this.servletName = st.nextToken();
            }
            this.verifyFilterValue();
        }
        String servletTitle = localStrings.getString("commands.monitor.servlet_title", new Object[]{this.filter});
        String title = String.format("%1$50s", servletTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    @Override
    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        Map webMap = null;
        if (this.appName == null) {
            webMap = this.srm.getWebModuleVirtualServerMonitorMap();
        } else {
            Map appMap = this.srm.getApplicationMonitorMap();
            if (appMap == null || appMap.size() < 1) {
                this.cancelMonitorTask();
                return;
            }
            ApplicationMonitor am = (ApplicationMonitor)appMap.get(this.appName);
            webMap = am.getWebModuleVirtualServerMonitorMap();
        }
        if (webMap == null || webMap.size() < 1) {
            this.cancelMonitorTask();
            return;
        }
        ServletMonitor servletMonitor = this.getServletFromWebModule(webMap);
        if (servletMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        AltServletStats servletStats = servletMonitor.getAltServletStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(servletStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private ServletMonitor getServletFromWebModule(Map<String, WebModuleVirtualServerMonitor> webMap) {
        WebModuleVirtualServerMonitor webmoduleVS = webMap.get(this.webName);
        Map servletMap = webmoduleVS.getServletMonitorMap();
        return (ServletMonitor)servletMap.get(this.servletName);
    }

    private String[] possibleAppModuleFilters() {
        Map appModuleMap = this.srm.getApplicationMonitorMap();
        Vector<String> possibleFilters = new Vector<String>();
        if (appModuleMap != null && appModuleMap.size() > 0) {
            String[] appModules;
            for (String appModule : appModules = MapUtil.getKeyStrings((Map)appModuleMap)) {
                ApplicationMonitor am = (ApplicationMonitor)appModuleMap.get(appModule);
                Map innerWebModuleMap = am.getWebModuleVirtualServerMonitorMap();
                possibleFilters.addAll(this.getServletsInWebModules(appModule, innerWebModuleMap));
            }
        }
        return possibleFilters.toArray(new String[0]);
    }

    private String[] possibleWebModuleFilters() {
        Map webModuleMap = this.srm.getWebModuleVirtualServerMonitorMap();
        List<String> possibleFilters = this.getServletsInWebModules(null, webModuleMap);
        return possibleFilters.toArray(new String[0]);
    }

    private List<String> getServletsInWebModules(String appName, Map<String, WebModuleVirtualServerMonitor> webModuleMap) {
        Vector<String> possibleServlets = new Vector<String>();
        String[] webModules = MapUtil.getKeyStrings(webModuleMap);
        if (webModuleMap != null && webModuleMap.size() > 0) {
            for (String webModule : webModules) {
                String[] servlets;
                WebModuleVirtualServerMonitor webmoduleVS = webModuleMap.get(webModule);
                Map servletMap = webmoduleVS.getServletMonitorMap();
                for (String servlet : servlets = MapUtil.getKeyStrings((Map)servletMap)) {
                    if (appName == null) {
                        possibleServlets.add(webModule + ":" + servlet);
                        continue;
                    }
                    possibleServlets.add(appName + ":" + webModule + ":" + servlet);
                }
            }
        }
        return possibleServlets;
    }

    private void getDefaultFilter() throws MonitorTaskException {
        String[] appModuleFilters = this.possibleAppModuleFilters();
        String[] webModuleFilters = this.possibleWebModuleFilters();
        if (webModuleFilters.length < 1 && appModuleFilters.length < 1) {
            throw new MonitorTaskException("No value to monitor.");
        }
        if (webModuleFilters.length == 1 && appModuleFilters.length < 1) {
            this.filter = webModuleFilters[0];
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            this.webName = st.nextToken();
            this.servletName = st.nextToken();
        } else if (webModuleFilters.length < 1 && appModuleFilters.length == 1) {
            this.filter = appModuleFilters[0];
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            this.appName = st.nextToken();
            this.webName = st.nextToken();
            this.servletName = st.nextToken();
        } else {
            String msg = this.getAvailableFilterMessage(appModuleFilters, webModuleFilters);
            throw new MonitorTaskException(msg);
        }
    }

    private String getAvailableFilterMessage(String[] appModuleFilters, String[] webModuleFilters) {
        StringBuffer sb = new StringBuffer();
        sb.append(localStrings.getString("commands.monitor.more_than_one_monitoring_elements"));
        if (webModuleFilters.length > 0) {
            sb.append(localStrings.getString("commands.monitor.available_servlet_elements"));
            for (String webmodule : webModuleFilters) {
                sb.append("    ");
                sb.append(webmodule);
                sb.append("\n");
            }
        }
        if (appModuleFilters.length > 0) {
            sb.append(localStrings.getString("commands.monitor.available_servlet_elements_in_appmodule"));
            for (String appmodule : appModuleFilters) {
                sb.append("    ");
                sb.append(appmodule);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyFilterValue() throws MonitorTaskException {
        if (this.appName != null) {
            Map appModuleMap = this.srm.getApplicationMonitorMap();
            if (!appModuleMap.containsKey(this.appName)) throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.appName}));
            ApplicationMonitor am = (ApplicationMonitor)appModuleMap.get(this.appName);
            Map innerWebModuleMap = am.getWebModuleVirtualServerMonitorMap();
            boolean exist = this.checkIfServletExistInWebModule(innerWebModuleMap);
            if (exist) return;
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in2", new Object[]{this.servletName, this.appName, this.webName}));
        }
        Map webModuleMap = this.srm.getWebModuleVirtualServerMonitorMap();
        boolean exist = this.checkIfServletExistInWebModule(webModuleMap);
        if (exist) return;
        throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in1", new Object[]{this.servletName, this.webName}));
    }

    private boolean checkIfServletExistInWebModule(Map<String, WebModuleVirtualServerMonitor> webModuleMap) throws MonitorTaskException {
        if (!webModuleMap.containsKey(this.webName)) {
            if (this.appName == null) {
                throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.webName}));
            }
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in1", new Object[]{this.webName, this.appName}));
        }
        WebModuleVirtualServerMonitor webmoduleVS = webModuleMap.get(this.webName);
        Map servletMap = webmoduleVS.getServletMonitorMap();
        return servletMap.containsKey(this.servletName);
    }

    private void displayHeader() {
        String ec = localStrings.getString("commands.monitor.ec");
        String mt = localStrings.getString("commands.monitor.mt");
        String pt = localStrings.getString("commands.monitor.pt");
        String rc = localStrings.getString("commands.monitor.rc");
        String current = localStrings.getString("commands.monitor.current");
        String maxtm = localStrings.getString("commands.monitor.maxtm");
        String mintm = localStrings.getString("commands.monitor.mintm");
        String totaltm = localStrings.getString("commands.monitor.totaltm");
        String header = String.format("%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s %8$-8s", ec, mt, pt, rc, current, maxtm, mintm, totaltm);
        CLILogger.getInstance().printMessage(header);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.servlet_write_to_file"));
        }
    }

    private void displayData(AltServletStats stat) {
        String data = String.format("%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s %8$-8s", stat.getErrorCount().getCount(), stat.getMaxTime().getCount(), stat.getProcessingTime().getCount(), stat.getRequestCount().getCount(), stat.getServiceTime().getCount(), stat.getServiceTime().getMaxTime(), stat.getServiceTime().getMinTime(), stat.getServiceTime().getTotalTime());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s", stat.getErrorCount().getCount(), stat.getMaxTime().getCount(), stat.getProcessingTime().getCount(), stat.getRequestCount().getCount(), stat.getServiceTime().getCount(), stat.getServiceTime().getMaxTime(), stat.getServiceTime().getMinTime(), stat.getServiceTime().getTotalTime());
            this.writeToFile(fileData);
        }
    }

    @Override
    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.servlet_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

