/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.jesmf.lifecycle;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxServiceUrlFactory;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.security.SecuritySupportImpl;
import com.sun.enterprise.server.ServerContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;

public class JESMFLifeCycle
extends ServerLifecycleImpl {
    public static final byte STATUS_NOT_STARTED = 0;
    public static final byte STATUS_SHUTDOWN = 1;
    public static final byte STATUS_INITED = 2;
    public static final byte STATUS_STARTED = 4;
    public static final byte STATUS_READY = 8;
    public static final byte STATUS_TERMINATED = 0;
    private byte serverStatus = 0;
    private static final String PRODUCT_NAME = "ApplicationServer";
    private static final String PRODUCT_CODE_NAME = "com.sun.cmm.as";
    private static final String PRODUCT_PREFIX = "as";
    private static final String HOST_KEY = "host";
    private static final String PORT_KEY = "port";
    private static final String USER_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    private static final String PROTOCOL_KEY = "protocol";
    private static final String CERT_KEY = "certificate";
    private static final String DOMAIN_NAME_KEY = "domain";
    private static final String IS_DAS_KEY = "isDAS";
    private static final String DEF_CERT_ALIAS = "s1as";
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        if ((this.serverStatus & 2) == 2) {
            throw new IllegalStateException("JES MF is already initialized");
        }
        this.serverStatus = (byte)2;
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        this.serverStatus = (byte)(this.serverStatus | 4);
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
        this.serverStatus = (byte)(this.serverStatus | 8);
        try {
            String instanceName = sc.getInstanceName();
            ConfigContext cCtx = sc.getConfigContext();
            JMXConnectorConfig jcc = ServerHelper.getJMXConnectorInfo((ConfigContext)cCtx, (String)instanceName);
            JMXServiceURL url = JmxServiceUrlFactory.forRmiWithJndiInAppserver((String)jcc.getHost(), (int)Integer.parseInt(jcc.getPort()));
            String domainName = ServerHelper.getAdministrativeDomainName((ConfigContext)cCtx, (String)instanceName);
            boolean isDAS = ServerHelper.isDAS((ConfigContext)cCtx, (String)instanceName);
            Hashtable<String, Object> userData = new Hashtable<String, Object>();
            userData.put(HOST_KEY, jcc.getHost());
            userData.put(PORT_KEY, jcc.getPort());
            userData.put(USER_KEY, jcc.getUser());
            userData.put(PASSWORD_KEY, jcc.getPassword());
            userData.put(PROTOCOL_KEY, jcc.getProtocol());
            userData.put("com.sun.aas.instanceName", instanceName);
            userData.put(DOMAIN_NAME_KEY, domainName);
            userData.put(IS_DAS_KEY, new Boolean(isDAS));
            Certificate cert = this.getJmxConnectorCert(cCtx, instanceName);
            userData.put(CERT_KEY, cert);
            byte[] data = this.serializeUserData(userData);
            Class<?> c = Class.forName("com.sun.mfwk.discovery.MfDiscoveryResponder");
            Constructor<?> con = c.getConstructor(String.class, String.class, String.class, String.class, String.class, data.getClass(), Boolean.TYPE);
            Object responder = con.newInstance(PRODUCT_NAME, PRODUCT_CODE_NAME, PRODUCT_PREFIX, instanceName, url.toString(), data, true);
            _logger.log(Level.INFO, "jesmf.discovery.init");
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.FINE, "com.sun.mfwk.discovery.MfDiscoveryResponder is not in the server classpath", cnfe);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Error while initializing MfDiscoveryResponder", e);
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        this.serverStatus = (byte)(this.serverStatus | 1);
    }

    public void onTermination() throws ServerLifecycleException {
        this.serverStatus = 0;
    }

    private String getCertNickname(ConfigContext ctx, String instanceName) throws ConfigException {
        Ssl ssl;
        String certNickname = null;
        JmxConnector con = ServerHelper.getServerSystemConnector((ConfigContext)ctx, (String)instanceName);
        if (con != null && (ssl = con.getSsl()) != null) {
            certNickname = ssl.getCertNickname();
        }
        if (certNickname == null) {
            certNickname = DEF_CERT_ALIAS;
        }
        return certNickname;
    }

    private Certificate getJmxConnectorCert(ConfigContext ctx, String instanceName) throws KeyStoreException, ConfigException {
        Certificate cert = null;
        String certNickname = this.getCertNickname(ctx, instanceName);
        SecuritySupportImpl ssi = new SecuritySupportImpl();
        KeyStore[] trustStore = ssi.getTrustStores();
        for (int i = 0; i < trustStore.length && (cert = trustStore[i].getCertificate(certNickname)) == null; ++i) {
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeUserData(Object obj) throws NotSerializableException, IOException {
        byte[] data = null;
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.flush();
            data = bos.toByteArray();
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception ex) {}
        }
        return data;
    }
}

