/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.initialization.ServerConfigReader;
import com.sun.enterprise.ee.web.sessmgmt.BaseHASession;
import com.sun.enterprise.ee.web.sessmgmt.CleanupCapable;
import com.sun.enterprise.ee.web.sessmgmt.EEHADBHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.HAStore;
import com.sun.enterprise.ee.web.sessmgmt.HAStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.SessionFactory;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;
import com.sun.enterprise.ee.web.sessmgmt.StorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.enterprise.web.MonitorStatsCapable;
import com.sun.enterprise.web.ShutdownCleanupCapable;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.PersistentManagerBase;

public abstract class HAManagerBase
extends PersistentManagerBase
implements ShutdownCleanupCapable,
MonitorStatsCapable,
CleanupCapable {
    private static Logger _logger = null;
    protected SessionFactory _sessionFactory = null;
    protected WebModuleStatistics _statistics = new WebModuleStatistics();
    private Map _connectionsMap = Collections.synchronizedMap(new WeakHashMap(50));
    StorePool _pool = null;

    protected Session createNewSession() {
        Session sess = this.getSessionFactory().createSession((Manager)this);
        return sess;
    }

    public Session createEmptySession() {
        Session sess = this.getSessionFactory().createSession((Manager)this);
        return sess;
    }

    protected void insureValidConnection() throws IOException {
        HAStore store = (HAStore)this.getStore();
        store.getConnectionValidated(false);
    }

    protected void processExpires() {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        try {
            this.insureValidConnection();
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.getStore() != null && this.getStore() instanceof HAStore) {
            ((HAStore)this.getStore()).processStaleCachedSessions();
        }
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        try {
            this.insureValidConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.processExpires();
    }

    public void processPersistenceChecks() {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        try {
            this.insureValidConnection();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.processMaxIdleSwaps();
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        try {
            this.insureValidConnection();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.processMaxActiveSwaps();
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        try {
            this.insureValidConnection();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.processMaxIdleBackups();
    }

    public Session findSession(String id) throws IOException {
        WebModuleStatistics stats = this.getWebModuleStatistics();
        if (!this.isSessionIdValid(id)) {
            if (this.isMonitoringEnabled()) {
                stats.processCacheHit(false);
            }
            return null;
        }
        Session session = this.findSessionFromCacheOnly(id);
        if (session != null) {
            if (this.isMonitoringEnabled()) {
                stats.processCacheHit(true);
            }
            return session;
        }
        if (this.isMonitoringEnabled()) {
            stats.processCacheHit(false);
        }
        session = this.swapIn(id);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN HAManagerBase>>findSession: returned sess = " + (BaseHASession)session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session findSessionFromCacheOnly(String id) throws IOException {
        if (id == null) {
            return null;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session session = (Session)this.sessions.get(id);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemove(String sessionId) {
        long startTime = 0L;
        StorePool storePool = this.getStorePool();
        HAStorePoolElement haStore = null;
        try {
            haStore = (HAStorePoolElement)storePool.take();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("GOT HAStore from pool");
            }
            try {
                haStore.setManager((Manager)this);
                ((HAStore)haStore).doRemove(sessionId);
                HAStore backgroundStore = (HAStore)this.getStore();
                backgroundStore.getSessions().remove((Object)sessionId);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                haStore.setManager(null);
                if (haStore != null) {
                    try {
                        storePool.put((StorePoolElement)haStore);
                    }
                    catch (InterruptedException ex1) {}
                }
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    protected boolean isMonitoringEnabled() {
        return ServerConfigReader.isMonitoringEnabled();
    }

    public String getMonitorAttributeValues() {
        return "testing..1..2..3";
    }

    public int getSessionsCacheSize() {
        return this.sessions.size();
    }

    public void stop() throws LifecycleException {
        super.stop();
        this.closeAllConnections();
    }

    public int doShutdownCleanup() {
        return this.closeAllConnections();
    }

    public int closeAllConnections() {
        int count = 0;
        int iterations = 0;
        Set connections = this._connectionsMap.keySet();
        Iterator it = connections.iterator();
        while (it.hasNext()) {
            ++iterations;
            Connection nextConn = (Connection)it.next();
            if (nextConn == null) continue;
            try {
                nextConn.close();
                ++count;
            }
            catch (SQLException ex) {
                break;
            }
        }
        return count;
    }

    public void clearStore() {
        super.clearStore();
        this.doCloseCachedConnection();
    }

    public void doCloseCachedConnection() {
        HAStore theStore = (HAStore)this.getStore();
        theStore.closeConnection();
    }

    SessionFactory getSessionFactory() {
        return this._sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    public WebModuleStatistics getWebModuleStatistics() {
        return this._statistics;
    }

    public void setWebModuleStatistics(WebModuleStatistics statistics) {
        this._statistics = statistics;
    }

    public Map getConnectionsMap() {
        return this._connectionsMap;
    }

    public synchronized void putConnection(Connection conn) {
        this._connectionsMap.put(conn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSessionIdsFromManagerCache(String[] sessionIds) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            for (int i = 0; i < sessionIds.length; ++i) {
                String nextId = sessionIds[i];
                if (nextId == null) continue;
                this.sessions.remove(nextId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionFromManagerCache(Session session) {
        if (session == null) {
            return;
        }
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(session.getId());
        }
    }

    public void resetMonitorStats() {
        WebModuleStatistics stats = this.getWebModuleStatistics();
        stats.resetStats();
    }

    public StorePool getStorePool() {
        return this._pool;
    }

    public void setStorePool(StorePool pool) {
        this._pool = pool;
    }

    public void doCleanup() {
        HAStore theStore = (HAStore)this.getStore();
        theStore.closeStatements();
    }

    static {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }
}

