/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv;

import com.sun.mfwk.CMM_MBean;
import com.sun.mfwk.MfAgentNode;
import com.sun.mfwk.MfObjectFactory;
import com.sun.mfwk.agent.appserv.connection.ConnectionRegistry;
import com.sun.mfwk.agent.appserv.discovery.ASMBeanDiscoveryService;
import com.sun.mfwk.agent.appserv.discovery.ASMBeanDiscoveryServiceFactory;
import com.sun.mfwk.agent.appserv.discovery.CMMMBeanDiscoveryService;
import com.sun.mfwk.agent.appserv.discovery.CMMMBeanDiscoveryServiceFactory;
import com.sun.mfwk.agent.appserv.lifecycle.ListenerImpl;
import com.sun.mfwk.agent.appserv.lifecycle.ListenerManager;
import com.sun.mfwk.agent.appserv.lifecycle.ListenerManagerFactory;
import com.sun.mfwk.agent.appserv.mapping.AS_ObjectNameNotFoundException;
import com.sun.mfwk.agent.appserv.mapping.MappingQueryService;
import com.sun.mfwk.agent.appserv.mapping.MappingQueryServiceFactory;
import com.sun.mfwk.agent.appserv.modeler.MBeanModeler;
import com.sun.mfwk.agent.appserv.modeler.ModelerContext;
import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import com.sun.mfwk.agent.appserv.relation.RelationModeler;
import com.sun.mfwk.agent.appserv.util.Utils;
import com.sun.mfwk.relations.RelationServiceImpl;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ASServerManager {
    private ModelerContext _context = null;
    private String _serverName = null;
    private String _domainName = null;
    private static final String JVM_PATTERN = ":type=CMM_JVM,domain=${domain.name},server=${server.name},name=${server.name}";
    private MBeanModeler _mBeanModeler = null;
    private RelationModeler _relationModeler = null;
    private MappingQueryService _queryService = null;

    public ASServerManager(String serverName, String domainName) {
        this("com.sun.cmm.as", serverName, domainName);
    }

    public ASServerManager(String moduleName, String serverName, String domainName) {
        this._serverName = serverName;
        this._domainName = domainName;
        this._context = new ModelerContext(serverName, domainName);
        this._context.setModuleName(moduleName);
        this._mBeanModeler = new MBeanModeler(this._context);
        this._relationModeler = new RelationModeler(this._context);
    }

    public void addToken(String key, String val) {
        this._context.addToken(key, val);
    }

    public void load() throws Exception {
        this.loadMBeans();
        this.loadRelations();
    }

    public void load(Set mbeans) throws Exception {
        this.loadMBeans(mbeans);
        this.loadRelations(mbeans);
    }

    public void load(ObjectName asObjectName) throws Exception {
        this.loadMBeans(asObjectName);
        this.loadRelations(asObjectName);
    }

    private void loadMBeans() throws Exception {
        this.loadMBeans(this.discoverASMonitorMBeans());
    }

    public void loadMBeans(Set mbeans) throws IOException, MalformedObjectNameException {
        if (mbeans == null) {
            throw new IllegalArgumentException();
        }
        MBeanModeler mm = new MBeanModeler(this._context);
        MappingQueryServiceFactory mqsf = MappingQueryServiceFactory.getInstance();
        MappingQueryService queryService = mqsf.getMappingQueryService(this._serverName, this._domainName);
        for (ObjectName on : mbeans) {
            try {
                mm.model(on, queryService);
            }
            catch (AS_ObjectNameNotFoundException onfe) {
                Utils.log(Level.INFO, "No mbean mapping found for: " + on);
            }
            catch (Exception e) {
                Utils.log(Level.INFO, "Error while instrumenting mbean: " + on.getCanonicalName(), e);
            }
        }
    }

    public void loadMBeans(ObjectName asObjectName) throws IOException, MalformedObjectNameException {
        if (this._queryService == null) {
            this.initQueryService();
        }
        if (this._queryService != null) {
            try {
                this._mBeanModeler.model(asObjectName, this._queryService);
            }
            catch (AS_ObjectNameNotFoundException onfe) {
                Utils.log(Level.INFO, "No mbean mapping found for: " + asObjectName);
            }
            catch (Exception e) {
                Utils.log(Level.INFO, "Error while instrumenting mbean: " + asObjectName.getCanonicalName(), e);
            }
        } else {
            Utils.log(Level.WARNING, "Not able to get hold of Mapping Query Service");
        }
    }

    private void loadRelations() throws Exception {
        RelationModeler rm = new RelationModeler(this._context);
        rm.load(this._serverName);
    }

    private void loadRelations(Set mbeans) throws Exception {
        RelationModeler rm = new RelationModeler(this._context);
        MappingQueryServiceFactory fac = MappingQueryServiceFactory.getInstance();
        MappingQueryService mqs = fac.getMappingQueryService(this._serverName, this._domainName);
        HashSet<ObjectName> CMM_Mbeans = new HashSet<ObjectName>();
        Iterator iter = mbeans.iterator();
        ObjectName asObjectName = null;
        while (iter.hasNext()) {
            asObjectName = (ObjectName)iter.next();
            NodeList nodes = mqs.getCMM_Mbeans(asObjectName.toString());
            String cmmNameTemplate = null;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elem = (Element)nodes.item(i);
                cmmNameTemplate = mqs.getCMM_ObjectName(elem);
                String cmmName = ObjectNameHelper.tokenizeON(asObjectName, cmmNameTemplate, this._context.getTokens());
                CMMMBeanDiscoveryServiceFactory factory = CMMMBeanDiscoveryServiceFactory.getInstance();
                CMMMBeanDiscoveryService dis = factory.getCMMMBeanDiscoveryService();
                ObjectName cmmObjectName = dis.discoverCMMMBean(cmmName);
                if (cmmObjectName == null) continue;
                CMM_Mbeans.add(cmmObjectName);
            }
        }
        rm.load(CMM_Mbeans);
    }

    private void loadRelations(ObjectName asObjectName) throws Exception {
        if (this._queryService == null) {
            this.initQueryService();
        }
        if (this._queryService != null) {
            HashSet<ObjectName> CMM_Mbeans = new HashSet<ObjectName>();
            NodeList nodes = this._queryService.getCMM_Mbeans(asObjectName.toString());
            String cmmNameTemplate = null;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element elem = (Element)nodes.item(i);
                cmmNameTemplate = this._queryService.getCMM_ObjectName(elem);
                String cmmName = ObjectNameHelper.tokenizeON(asObjectName, cmmNameTemplate, this._context.getTokens());
                CMMMBeanDiscoveryServiceFactory factory = CMMMBeanDiscoveryServiceFactory.getInstance();
                CMMMBeanDiscoveryService dis = factory.getCMMMBeanDiscoveryService();
                ObjectName cmmObjectName = dis.discoverCMMMBean(cmmName);
                if (cmmObjectName == null) continue;
                CMM_Mbeans.add(cmmObjectName);
            }
            this._relationModeler.load(CMM_Mbeans);
        } else {
            Utils.log(Level.WARNING, "Not able to get hold of Mapping Query Service");
        }
    }

    public void unload(Set mbeans) throws Exception {
        if (mbeans == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = mbeans.iterator();
        ObjectName objectName = null;
        MfObjectFactory mfObjectFactory = MfObjectFactory.getObjectFactory((String)this._context.getModuleName());
        RelationServiceImpl relationService = RelationServiceImpl.getRelationService();
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            try {
                RelationModeler rm = new RelationModeler(this._context);
                rm.removeRelations(objectName.getCanonicalName());
            }
            catch (Exception e) {
                Utils.log(Level.INFO, "Error while deleting relation for: " + objectName, e);
            }
            try {
                mfObjectFactory.deleteObject(objectName.toString());
            }
            catch (Exception exception) {
                Utils.log(Level.INFO, "Error while deleting mbean: " + objectName, exception);
            }
        }
    }

    public void start() throws Exception {
        MfObjectFactory fac;
        String mn;
        try {
            String str = "com.sun.cmm.as:type=CMM_J2eeDomain,name=" + this._domainName;
            mn = this._context.getModuleName();
            fac = MfObjectFactory.getObjectFactory((String)mn);
            fac.createObject(str);
        }
        catch (Exception e) {
            Utils.log(Level.WARNING, "Error creating domain cmm mbean", e);
        }
        this.load();
        ListenerManager listenerManager = ListenerManagerFactory.getListenerManager();
        try {
            ListenerImpl listener = new ListenerImpl(this._serverName, this._domainName);
            listenerManager.addNotificationListener(this._serverName, this._domainName, listener, null, null);
        }
        catch (Exception ex) {
            Utils.log(Level.SEVERE, "Error while registering dynamic config listener", ex);
        }
        try {
            mn = this._context.getModuleName();
            fac = MfObjectFactory.getObjectFactory((String)mn);
            String tokenizedON = ObjectNameHelper.tokenize(mn + JVM_PATTERN, this._context.getTokens());
            CMM_MBean jvmMbean = fac.getObject(tokenizedON);
            if (jvmMbean != null) {
                MfAgentNode.createRelationsWithAgent((String)mn, (CMM_MBean)jvmMbean);
            }
        }
        catch (Exception e) {
            Utils.log(Level.INFO, "Error while creating JVM relation with the node agent", e);
        }
    }

    public void stop() throws IOException, MalformedObjectNameException, Exception {
        CMMMBeanDiscoveryServiceFactory fac = CMMMBeanDiscoveryServiceFactory.getInstance();
        CMMMBeanDiscoveryService dis = fac.getCMMMBeanDiscoveryService();
        Set mbeans = dis.discoverCMMMBeans(this._serverName, this._domainName);
        this.unload(mbeans);
        ConnectionRegistry reg = ConnectionRegistry.getInstance();
        reg.removeConnection(this._serverName, this._domainName);
    }

    private Set discoverASMonitorMBeans() throws Exception {
        MBeanServerConnection dasConn;
        ConnectionRegistry registry = ConnectionRegistry.getInstance();
        MBeanServerConnection con = registry.getConnection(this._serverName, this._domainName);
        ASMBeanDiscoveryService discoveryService = ASMBeanDiscoveryServiceFactory.getInstance().getASMBeanDiscoveryService(con);
        Set asMBeans = discoveryService.discoverASMBeans(this._serverName);
        try {
            dasConn = registry.getConnection("server", this._domainName);
        }
        catch (Exception e) {
            dasConn = null;
            Utils.log(Level.INFO, "Not able to get hold of DAS Connection. Not instrumenting Cluster objects");
        }
        if (dasConn != null) {
            ASMBeanDiscoveryService dasDiscoveryService = ASMBeanDiscoveryServiceFactory.getInstance().getASMBeanDiscoveryService(dasConn);
            asMBeans.addAll(dasDiscoveryService.discoverClusterMBeans());
        }
        return asMBeans;
    }

    private void initQueryService() throws IOException {
        MappingQueryServiceFactory mqsf = MappingQueryServiceFactory.getInstance();
        this._queryService = mqsf.getMappingQueryService(this._serverName, this._domainName);
    }
}

