/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.lifecycle.beans;

import com.sun.mfwk.agent.appserv.lifecycle.beans.Notifications;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Mapping {
    public static final String RUNTIME_MBEAN_ATTRIBUTE_NAME = "RuntimeMbeanAttributeName";
    public static final String MONITORING_MBEAN_ATTRIBUTE_VALUE = "MonitoringMbeanAttributeValue";
    private String _RuntimeMbeanAttributeName;
    private String _MonitoringMbeanAttributeValue;

    public Mapping() {
        this._RuntimeMbeanAttributeName = "";
        this._MonitoringMbeanAttributeValue = "";
    }

    public Mapping(String runtimeMbeanAttributeName, String monitoringMbeanAttributeValue) {
        this._RuntimeMbeanAttributeName = runtimeMbeanAttributeName;
        this._MonitoringMbeanAttributeValue = monitoringMbeanAttributeValue;
    }

    public Mapping(Mapping source) {
        this(source, false);
    }

    public Mapping(Mapping source, boolean justData) {
        this._RuntimeMbeanAttributeName = source._RuntimeMbeanAttributeName;
        this._MonitoringMbeanAttributeValue = source._MonitoringMbeanAttributeValue;
    }

    public void setRuntimeMbeanAttributeName(String value) {
        this._RuntimeMbeanAttributeName = value;
    }

    public String getRuntimeMbeanAttributeName() {
        return this._RuntimeMbeanAttributeName;
    }

    public void setMonitoringMbeanAttributeValue(String value) {
        this._MonitoringMbeanAttributeValue = value;
    }

    public String getMonitoringMbeanAttributeValue() {
        return this._MonitoringMbeanAttributeValue;
    }

    public void writeNode(Writer out) throws IOException {
        String myName = "mapping";
        this.writeNode(out, myName, "");
    }

    public void writeNode(Writer out, String nodeName, String indent) throws IOException {
        this.writeNode(out, nodeName, null, indent, new HashMap());
    }

    public void writeNode(Writer out, String nodeName, String namespace, String indent, Map namespaceMap) throws IOException {
        out.write(indent);
        out.write("<");
        if (namespace != null) {
            out.write((String)namespaceMap.get(namespace));
            out.write(":");
        }
        out.write(nodeName);
        out.write(">\n");
        String nextIndent = indent + "\t";
        if (this._RuntimeMbeanAttributeName != null) {
            out.write(nextIndent);
            out.write("<runtime-mbean-attribute-name");
            out.write(">");
            Notifications.writeXML(out, this._RuntimeMbeanAttributeName, false);
            out.write("</runtime-mbean-attribute-name>\n");
        }
        if (this._MonitoringMbeanAttributeValue != null) {
            out.write(nextIndent);
            out.write("<monitoring-mbean-attribute-value");
            out.write(">");
            Notifications.writeXML(out, this._MonitoringMbeanAttributeValue, false);
            out.write("</monitoring-mbean-attribute-value>\n");
        }
        out.write(indent);
        out.write("</");
        if (namespace != null) {
            out.write((String)namespaceMap.get(namespace));
            out.write(":");
        }
        out.write(nodeName);
        out.write(">\n");
    }

    public void readNode(Node node) {
        this.readNode(node, new HashMap());
    }

    public void readNode(Node node, Map namespacePrefixes) {
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            boolean firstNamespaceDef = true;
            for (int attrNum = 0; attrNum < attrs.getLength(); ++attrNum) {
                Attr attr = (Attr)attrs.item(attrNum);
                String attrName = attr.getName();
                if (!attrName.startsWith("xmlns:")) continue;
                if (firstNamespaceDef) {
                    firstNamespaceDef = false;
                    namespacePrefixes = new HashMap<String, String>(namespacePrefixes);
                }
                String attrNSPrefix = attrName.substring(6, attrName.length());
                namespacePrefixes.put(attrNSPrefix, attr.getValue());
            }
        }
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getLocalName() == null ? childNode.getNodeName().intern() : childNode.getLocalName().intern();
            String childNodeValue = "";
            if (childNode.getFirstChild() != null) {
                childNodeValue = childNode.getFirstChild().getNodeValue();
            }
            if (childNodeName == "runtime-mbean-attribute-name") {
                this._RuntimeMbeanAttributeName = childNodeValue;
                continue;
            }
            if (childNodeName != "monitoring-mbean-attribute-value") continue;
            this._MonitoringMbeanAttributeValue = childNodeValue;
        }
    }

    public void validate() throws Notifications.ValidateException {
        boolean restrictionFailure = false;
        if (this.getRuntimeMbeanAttributeName() == null) {
            throw new Notifications.ValidateException("getRuntimeMbeanAttributeName() == null", Notifications.ValidateException.FailureType.NULL_VALUE, "runtimeMbeanAttributeName", this);
        }
        if (this.getMonitoringMbeanAttributeValue() == null) {
            throw new Notifications.ValidateException("getMonitoringMbeanAttributeValue() == null", Notifications.ValidateException.FailureType.NULL_VALUE, "monitoringMbeanAttributeValue", this);
        }
    }

    public void changePropertyByName(String name, Object value) {
        if (name == null) {
            return;
        }
        if ((name = name.intern()) == "runtimeMbeanAttributeName") {
            this.setRuntimeMbeanAttributeName((String)value);
        } else if (name == "monitoringMbeanAttributeValue") {
            this.setMonitoringMbeanAttributeValue((String)value);
        } else {
            throw new IllegalArgumentException(name + " is not a valid property name for Mapping");
        }
    }

    public Object fetchPropertyByName(String name) {
        if (name == "runtimeMbeanAttributeName") {
            return this.getRuntimeMbeanAttributeName();
        }
        if (name == "monitoringMbeanAttributeValue") {
            return this.getMonitoringMbeanAttributeValue();
        }
        throw new IllegalArgumentException(name + " is not a valid property name for Mapping");
    }

    public String nameSelf() {
        return "Mapping";
    }

    public String nameChild(Object childObj) {
        return this.nameChild(childObj, false, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName) {
        return this.nameChild(childObj, returnConstName, returnSchemaName, false);
    }

    public String nameChild(Object childObj, boolean returnConstName, boolean returnSchemaName, boolean returnXPathName) {
        if (childObj instanceof String) {
            String child = (String)childObj;
            if (child == this._RuntimeMbeanAttributeName) {
                if (returnConstName) {
                    return RUNTIME_MBEAN_ATTRIBUTE_NAME;
                }
                if (returnSchemaName) {
                    return "runtime-mbean-attribute-name";
                }
                if (returnXPathName) {
                    return "runtime-mbean-attribute-name";
                }
                return RUNTIME_MBEAN_ATTRIBUTE_NAME;
            }
            if (child == this._MonitoringMbeanAttributeValue) {
                if (returnConstName) {
                    return MONITORING_MBEAN_ATTRIBUTE_VALUE;
                }
                if (returnSchemaName) {
                    return "monitoring-mbean-attribute-value";
                }
                if (returnXPathName) {
                    return "monitoring-mbean-attribute-value";
                }
                return MONITORING_MBEAN_ATTRIBUTE_VALUE;
            }
        }
        return null;
    }

    public Object[] childBeans(boolean recursive) {
        LinkedList children = new LinkedList();
        this.childBeans(recursive, children);
        Object[] result = new Object[children.size()];
        return children.toArray(result);
    }

    public void childBeans(boolean recursive, List beans) {
    }

    public boolean equals(Object o) {
        return o instanceof Mapping && this.equals((Mapping)o);
    }

    public boolean equals(Mapping inst) {
        if (inst == this) {
            return true;
        }
        if (inst == null) {
            return false;
        }
        if (!(this._RuntimeMbeanAttributeName != null ? this._RuntimeMbeanAttributeName.equals(inst._RuntimeMbeanAttributeName) : inst._RuntimeMbeanAttributeName == null)) {
            return false;
        }
        return this._MonitoringMbeanAttributeValue != null ? this._MonitoringMbeanAttributeValue.equals(inst._MonitoringMbeanAttributeValue) : inst._MonitoringMbeanAttributeValue == null;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this._RuntimeMbeanAttributeName == null ? 0 : this._RuntimeMbeanAttributeName.hashCode());
        result = 37 * result + (this._MonitoringMbeanAttributeValue == null ? 0 : this._MonitoringMbeanAttributeValue.hashCode());
        return result;
    }
}

