/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.modeler;

import com.sun.mfwk.CMM_MBean;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import com.sun.mfwk.agent.appserv.mapping.AS_ObjectNameNotFoundException;
import com.sun.mfwk.agent.appserv.mapping.MappingQueryService;
import com.sun.mfwk.agent.appserv.modeler.ConfigReader;
import com.sun.mfwk.agent.appserv.modeler.MBeanFactory;
import com.sun.mfwk.agent.appserv.modeler.ModelerContext;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MBeanModeler {
    private ModelerContext _context;

    public MBeanModeler(ModelerContext ctx) {
        this._context = ctx;
    }

    public void model(ObjectName on, MappingQueryService mapping) throws IOException, AS_ObjectNameNotFoundException {
        if (on == null || mapping == null) {
            throw new IllegalArgumentException();
        }
        NodeList cmmNodeList = mapping.getCMM_Mbeans(on.getCanonicalName());
        MBeanFactory mf = new MBeanFactory(this._context);
        int size = cmmNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            Element m = (Element)cmmNodeList.item(i);
            try {
                mf.model(on, m, mapping);
                continue;
            }
            catch (Exception e) {
                LogDomains.getLogger().log(Level.WARNING, "Error while modeling mbean " + on, e);
            }
        }
    }

    public void load(String template, String dLocation) throws IOException {
        NodeList list = ConfigReader.getMBeans(template, dLocation);
        int size = list.getLength();
        MBeanFactory mf = new MBeanFactory(this._context);
        Logger l = LogDomains.getLogger();
        for (int i = 0; i < size; ++i) {
            Element m = (Element)list.item(i);
            try {
                CMM_MBean mbean = mf.create(m);
                if (l == null || mbean == null) continue;
                l.fine("Created MBean: " + mbean.getName());
                continue;
            }
            catch (Exception e) {
                LogDomains.getLogger().log(Level.WARNING, "Error while instrumenting mbean", e);
            }
        }
    }

    public static Map getDelegateMap() {
        if (MBeanFactory.map == null) {
            MBeanFactory.map = new Hashtable();
        }
        return MBeanFactory.map;
    }
}

