/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.util;

import com.sun.mfwk.agent.appserv.ASEntityResolver;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Utils {
    public static Document getDocument(String url, String defaultLocation) throws IOException {
        Document doc = null;
        InputStream in = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new ASEntityResolver());
            try {
                ClassLoader cl = Utils.class.getClassLoader();
                in = cl.getResourceAsStream(url);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (in == null) {
                in = new FileInputStream(defaultLocation + url);
            }
            doc = db.parse(in);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXParseException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {}
            }
        }
        return doc;
    }

    public static InputStream getInputStream(String relativeFilePath) {
        if (relativeFilePath == null) {
            throw new IllegalArgumentException();
        }
        ClassLoader cl = Utils.class.getClassLoader();
        return cl.getResourceAsStream(relativeFilePath);
    }

    public static String getStringRegion(String source, String beginsWith, String endsWith) {
        String region = null;
        int beginIndex = source.indexOf(beginsWith);
        if (beginIndex >= 0) {
            int endIndex = source.indexOf(endsWith, beginIndex + beginsWith.length());
            if (endIndex < 0) {
                endIndex = source.length();
            }
            region = source.substring(beginIndex + beginsWith.length(), endIndex);
        }
        return region;
    }

    public boolean isDAS(String serverName) {
        return "server".equals(serverName);
    }

    public static void log(Level level, String message, Exception e) {
        Logger logger = LogDomains.getLogger();
        if (logger != null) {
            logger.log(level, message, e);
        }
    }

    public static void log(Level level, String message) {
        Logger logger = LogDomains.getLogger();
        if (logger != null) {
            logger.log(level, message);
        }
    }

    public static long getAttributeSum(MBeanServerConnection connection, Set objectNames, String attribute) {
        long attributeSum = 0L;
        Iterator iter = objectNames.iterator();
        ObjectName objectName = null;
        while (iter.hasNext()) {
            Long attributeValue;
            objectName = (ObjectName)iter.next();
            try {
                attributeValue = (Long)connection.getAttribute(objectName, attribute);
            }
            catch (Exception exception) {
                Utils.log(Level.WARNING, "Error getting attribute, " + attribute + " of" + objectName, exception);
                continue;
            }
            attributeSum += attributeValue.longValue();
        }
        return attributeSum;
    }
}

