/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.bean;

import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jbi.jsf.bean.SelectableJBIComponentInfo;
import com.sun.jbi.jsf.bean.SelectableJBIServiceAssemblyInfo;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.ClusterUtilities;
import com.sun.jbi.jsf.util.I18nUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIComponentInfo;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.webui.jsf.model.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBean {
    private static final boolean IS_CLUSTER_PROFILE = ClusterUtilities.isClusterProfile();
    private static final String LIST_TARGET = "domain";
    private static final String NO_STATE_CHECK = null;
    private static final String NO_LIBRARY_CHECK = null;
    private static final String NO_COMPONENT_CHECK = null;
    private static final String NO_DEPLOYMENT_CHECK = null;
    private static Logger sLog = JBILogger.getInstance();
    private String[] mUpdateList;
    private TableDataProvider mCachedTableData = null;
    private TableDataProvider mCachedDepsTableData = null;
    private JBIAdminCommands mJac = BeanUtilities.getClient();
    private Option[] testCaseOptions = null;
    private String mFilterType = "Show All";
    private String mFilterComponentState = "Show All";
    private ArrayList mFilterComponentStates = null;
    private String mFilterAssemblyState = "Show All";
    private ArrayList mFilterAssemblyStates = null;

    public static String findDescription(String aName, List aComponentOrServiceAssemblyInfoList) {
        String result = "";
        sLog.fine("ListBean.findDescription(" + aName + ", (List)) size=" + aComponentOrServiceAssemblyInfoList.size());
        if (null != aName && null != aComponentOrServiceAssemblyInfoList) {
            String nextDescription = "";
            String nextName = "";
            for (int i = 0; i < aComponentOrServiceAssemblyInfoList.size(); ++i) {
                Object listItem = aComponentOrServiceAssemblyInfoList.get(i);
                sLog.fine("ListBean.findDescription(...), listItem=" + listItem);
                if (listItem instanceof SelectableJBIComponentInfo) {
                    SelectableJBIComponentInfo nextCompInfo = (SelectableJBIComponentInfo)((Object)listItem);
                    nextDescription = nextCompInfo.getDescription();
                    nextName = nextCompInfo.getName();
                } else if (listItem instanceof SelectableJBIServiceAssemblyInfo) {
                    SelectableJBIServiceAssemblyInfo nextDepInfo = (SelectableJBIServiceAssemblyInfo)((Object)listItem);
                    nextDescription = nextDepInfo.getDescription();
                    nextName = nextDepInfo.getName();
                }
                if (!aName.equals(nextName)) continue;
                result = nextDescription;
                break;
            }
        }
        sLog.fine("ListBean.findDescription(" + aName + ", " + aComponentOrServiceAssemblyInfoList + "), result=" + result);
        return result;
    }

    List<SelectableJBIComponentInfo> getBindingComponentsInfoList() {
        sLog.fine("ListBean.getBindingComponentsInfoList()");
        return this.getBindingComponentsInfoList(this.mFilterComponentState, this.mFilterComponentStates);
    }

    List<SelectableJBIComponentInfo> getBindingComponentsInfoList(String aFilterState, ArrayList aFilterStates) {
        sLog.fine("ListBean.getBindingComponentsInfoList(" + aFilterState + ", " + aFilterStates + ")");
        ArrayList<SelectableJBIComponentInfo> resultList = new ArrayList<SelectableJBIComponentInfo>();
        SelectableJBIComponentInfo[] bcInfoListArray = this.getCompStatus("binding-component");
        for (int i = 0; i < bcInfoListArray.length; ++i) {
            if (!BeanUtilities.checkFilterOptions(bcInfoListArray[i].getSummaryStatus(), aFilterState, aFilterStates)) continue;
            sLog.fine("ListBean.getBindingComponentsInfoList() adding " + (Object)((Object)bcInfoListArray[i]));
            resultList.add(bcInfoListArray[i]);
        }
        return resultList;
    }

    List<SelectableJBIServiceAssemblyInfo> getServiceAssembliesInfoList() {
        sLog.fine("ListBean.getServiceAssembliesInfoList()");
        return this.getServiceAssembliesInfoList(this.mFilterAssemblyState, this.mFilterAssemblyStates);
    }

    List<SelectableJBIServiceAssemblyInfo> getServiceAssembliesInfoList(String aFilterState, ArrayList aFilterStates) {
        sLog.fine("ListBean.getServiceAssmembliesInfoList(" + aFilterState + ", " + aFilterStates + ")");
        ArrayList<SelectableJBIServiceAssemblyInfo> resultList = new ArrayList<SelectableJBIServiceAssemblyInfo>();
        SelectableJBIServiceAssemblyInfo[] saInfoListArray = this.getSaStatus();
        for (int i = 0; i < saInfoListArray.length; ++i) {
            if (!BeanUtilities.checkFilterOptions(saInfoListArray[i].getSummaryStatus(), aFilterState, aFilterStates)) continue;
            sLog.fine("ListBean.getServiceAssembliesInfoList() adding " + (Object)((Object)saInfoListArray[i]));
            resultList.add(saInfoListArray[i]);
        }
        return resultList;
    }

    List<SelectableJBIComponentInfo> getServiceEnginesInfoList() {
        sLog.fine("ListBean.getServiceEnginesInfoList()");
        return this.getServiceEnginesInfoList(this.mFilterComponentState, this.mFilterComponentStates);
    }

    List<SelectableJBIComponentInfo> getServiceEnginesInfoList(String aFilterState, ArrayList aFilterStates) {
        sLog.fine("ListBean.getServiceEnginesInfoList(" + aFilterState + ", " + aFilterStates + ")");
        ArrayList<SelectableJBIComponentInfo> resultList = new ArrayList<SelectableJBIComponentInfo>();
        SelectableJBIComponentInfo[] seInfoListArray = this.getCompStatus("service-engine");
        for (int i = 0; i < seInfoListArray.length; ++i) {
            if (!BeanUtilities.checkFilterOptions(seInfoListArray[i].getSummaryStatus(), aFilterState, aFilterStates)) continue;
            sLog.fine("ListBean.getServiceEnginesInfoList() adding " + (Object)((Object)seInfoListArray[i]));
            resultList.add(seInfoListArray[i]);
        }
        return resultList;
    }

    List<SelectableJBIComponentInfo> getSharedLibrariesInfoList() {
        String xmlQueryResults = this.getListSharedLibraries();
        ArrayList<SelectableJBIComponentInfo> result = new ArrayList<SelectableJBIComponentInfo>();
        List sharedLibrariesComponentInfoList = JBIComponentInfo.readFromXmlText((String)xmlQueryResults);
        Iterator it = sharedLibrariesComponentInfoList.iterator();
        while (it.hasNext()) {
            SelectableJBIComponentInfo next = new SelectableJBIComponentInfo((JBIComponentInfo)it.next());
            result.add(next);
        }
        sLog.fine("ListBean.getSharedLibrariesInfoList(), result=" + result);
        return result;
    }

    public String getListBindingComponents() {
        String result = "";
        try {
            if (null != this.mJac) {
                if (this.mJac.isJBIRuntimeEnabled()) {
                    result = this.mJac.listBindingComponents(LIST_TARGET);
                } else {
                    sLog.fine("ListBean.getListBindingComponents() scaffolding false");
                }
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            sLog.fine("ListBean.getListBindingComponents(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
        }
        catch (Exception unexpectedEx) {
            this.logSevereI18n(unexpectedEx);
        }
        return result;
    }

    public String getListServiceAssemblies() {
        String result = "";
        try {
            if (null != this.mJac) {
                if (this.mJac.isJBIRuntimeEnabled()) {
                    result = this.mJac.listServiceAssemblies(LIST_TARGET);
                } else {
                    sLog.fine("ListBean.getListServiceAssemblies() scaffolding false");
                }
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            sLog.fine("ListBean.getListServiceAssemblies(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
        }
        catch (Exception unexpectedEx) {
            this.logSevereI18n(unexpectedEx);
        }
        return result;
    }

    public String getListServiceEngines() {
        String result = "";
        try {
            if (null != this.mJac) {
                if (this.mJac.isJBIRuntimeEnabled()) {
                    result = this.mJac.listServiceEngines(LIST_TARGET);
                } else {
                    sLog.fine("ListBean.getListServiceEngines() scaffolding false");
                }
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            sLog.fine("ListBean.getListServiceEngines(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
        }
        catch (Exception unexpectedEx) {
            this.logSevereI18n(unexpectedEx);
        }
        return result;
    }

    public String getListSharedLibraries() {
        String result = "";
        try {
            if (null != this.mJac) {
                if (this.mJac.isJBIRuntimeEnabled()) {
                    result = this.mJac.listSharedLibraries(LIST_TARGET);
                } else {
                    sLog.fine("ListBean.getListSharedLibraries() scaffolding false");
                }
            }
        }
        catch (JBIRemoteException jbiRemoteEx) {
            sLog.fine("ListBean.getListSharedLibraries(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
        }
        catch (Exception unexpectedEx) {
            this.logSevereI18n(unexpectedEx);
        }
        sLog.fine("ListBean.getListShaerdLibraries(), result=" + result);
        return result;
    }

    public TableDataProvider getSharedTableData() {
        sLog.fine("ListBean.getSharedTableData()");
        TableDataProvider result = this.mCachedTableData;
        sLog.fine("ListBean.getSharedTableData(): result=" + result);
        return result;
    }

    public void setBindingsEnginesTableData() {
        List<SelectableJBIComponentInfo> combinedList = null;
        sLog.fine("ListBean.setBindingsEnginesTableData()");
        if ("Show All".equals(this.mFilterType)) {
            combinedList = this.getBindingComponentsInfoList();
            combinedList.addAll(this.getServiceEnginesInfoList());
        } else if ("Binding".equals(this.mFilterType)) {
            combinedList = this.getBindingComponentsInfoList();
        } else if ("Engine".equals(this.mFilterType)) {
            combinedList = this.getServiceEnginesInfoList();
        }
        ObjectListDataProvider result = new ObjectListDataProvider(combinedList);
        this.mCachedTableData = result;
        sLog.fine("ListBean.setBindingsEnginesTableData(): result=" + result);
    }

    public void setDeploymentsTableData() {
        sLog.fine("ListBean.setDeploymentsTableData()");
        ObjectListDataProvider result = new ObjectListDataProvider(this.getServiceAssembliesInfoList());
        this.mCachedTableData = result;
        sLog.fine("ListBean.setDeploymentsTableData(): result=" + result);
    }

    public void setLibrariesTableData() {
        sLog.fine("ListBean.setLibrariesTableData()");
        ObjectListDataProvider result = new ObjectListDataProvider(this.getSharedLibrariesInfoList());
        this.mCachedTableData = result;
        sLog.fine("ListBean.setLibrariesTableData(): result=" + result);
    }

    public void setFilterType(String filterType) {
        this.mFilterType = filterType;
    }

    public String getFilterType() {
        return this.mFilterType;
    }

    public void setFilterComponentState(String filterState) {
        this.mFilterComponentState = filterState;
    }

    public void setFilterComponentState(String filterState, String filterStates) {
        this.mFilterComponentState = filterState;
        filterStates = filterStates.replace('[', ' ');
        filterStates = filterStates.replace(']', ' ');
        String[] states = filterStates.split("\\,");
        for (int i = 0; i < states.length; ++i) {
            states[i] = states[i].trim();
        }
        this.mFilterComponentStates = new ArrayList<String>(Arrays.asList(states));
    }

    public String getFilterComponentState() {
        return this.mFilterComponentState;
    }

    public void setFilterAssemblyState(String filterState) {
        this.mFilterAssemblyState = filterState;
    }

    public void setFilterAssemblyState(String filterState, String filterStates) {
        this.mFilterAssemblyState = filterState;
        filterStates = filterStates.replace('[', ' ');
        filterStates = filterStates.replace(']', ' ');
        String[] states = filterStates.split("\\,");
        for (int i = 0; i < states.length; ++i) {
            states[i] = states[i].trim();
        }
        this.mFilterAssemblyStates = new ArrayList<String>(Arrays.asList(states));
    }

    public String getFilterAssemblyState() {
        return this.mFilterAssemblyState;
    }

    private SelectableJBIComponentInfo[] getCompStatus(String aType) {
        SelectableJBIComponentInfo[] result = new SelectableJBIComponentInfo[]{};
        if (IS_CLUSTER_PROFILE) {
            sLog.fine("ListBean.getCompStatus(" + aType + ") cluster-profile");
            result = ClusterUtilities.getCompStatus(aType);
        } else {
            sLog.fine("ListBean.getCompStatus(" + aType + ") developer-profile");
            List compInfoList = null;
            if ("binding-component".equals(aType)) {
                String listBcXmlQueryResults = this.getListBindingComponents();
                compInfoList = JBIComponentInfo.readFromXmlText((String)listBcXmlQueryResults);
            } else {
                String listSeXmlQueryResults = this.getListServiceEngines();
                compInfoList = JBIComponentInfo.readFromXmlText((String)listSeXmlQueryResults);
            }
            result = new SelectableJBIComponentInfo[compInfoList.size()];
            int index = 0;
            Iterator it = compInfoList.iterator();
            while (it.hasNext()) {
                SelectableJBIComponentInfo next = new SelectableJBIComponentInfo((JBIComponentInfo)it.next());
                sLog.fine("ListBean.getCompStatus(" + aType + ") next=" + (Object)((Object)next));
                result[index] = next;
                result[index].setSummaryStatus(result[index].getState());
                sLog.fine("ListBean.getCompStatus(" + aType + "), result[" + index + "].getState()=" + result[index].getState() + ")");
                ++index;
            }
        }
        sLog.fine("ListBean.getCompStatus(" + aType + "), result.length=" + result.length);
        return result;
    }

    private SelectableJBIServiceAssemblyInfo[] getSaStatus() {
        SelectableJBIServiceAssemblyInfo[] result = new SelectableJBIServiceAssemblyInfo[]{};
        if (IS_CLUSTER_PROFILE) {
            sLog.fine("ListBean.getSaStatus() cluster-profile");
            result = ClusterUtilities.getSaStatus();
        } else {
            sLog.fine("ListBean.getSaStatus() developer-profile");
            List saInfoList = null;
            String listSaXmlQueryResults = this.getListServiceAssemblies();
            saInfoList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)listSaXmlQueryResults);
            result = new SelectableJBIServiceAssemblyInfo[saInfoList.size()];
            int index = 0;
            Iterator it = saInfoList.iterator();
            while (it.hasNext()) {
                SelectableJBIServiceAssemblyInfo next = new SelectableJBIServiceAssemblyInfo((ServiceAssemblyInfo)it.next());
                sLog.fine("ListBean.getSaStatus() next=" + (Object)((Object)next));
                result[index] = next;
                result[index].setSummaryStatus(result[index].getState());
                sLog.fine("ListBean.getSaStatus(), result[" + index + "].getState()=" + result[index].getState() + ")");
                ++index;
            }
        }
        sLog.fine("ListBean.getSaStatus(), result.length=" + result.length);
        return result;
    }

    public void setUpdateInstancesList(String[] list) {
        this.mUpdateList = list;
    }

    public String[] getUpdateInstancesList() {
        return this.mUpdateList;
    }

    private void logSevereI18n(Exception anUnexpectedException) {
        sLog.fine("ListBean.logSevereI18n anUnexpectedException=" + anUnexpectedException);
        String exMsg = anUnexpectedException.getLocalizedMessage();
        sLog.fine("ListBean.logSevereI18n getLocalizedMessage=" + exMsg);
        if (null == exMsg) {
            exMsg = anUnexpectedException.getClass().getName();
            sLog.fine("ListBean.logSevereI18n exMsg=" + exMsg);
        }
        Object[] args = new Object[]{exMsg};
        String msg = null;
        try {
            msg = GuiUtil.getMessage((String)I18nUtilities.getResourceString("jbi.common.client.unexpected.exception"), (Object[])args);
        }
        catch (Exception unexpectedI18nEx) {
            sLog.fine("ListBean.logSevereI18n caught unexpectedI18nEx=" + unexpectedI18nEx);
            msg = I18nUtilities.getResourceString("jbi.internal.i18n.error");
        }
        sLog.severe(msg);
        anUnexpectedException.printStackTrace(System.err);
    }

    public TableDataProvider getSharedDepsTableData() {
        sLog.fine("ListBean.getSharedDepsTableData()");
        TableDataProvider result = this.mCachedDepsTableData;
        sLog.fine("ListBean.getSharedDepsTableData(): result=" + result);
        return result;
    }

    public void setSharedDepsTableData(String aType, String aName) {
        sLog.fine("ListBean.setSharedDepsTableData(" + aType + ", " + aName + ")");
        List compInfoList = null;
        try {
            if (null != this.mJac) {
                if (this.mJac.isJBIRuntimeEnabled()) {
                    if ("shared-library".equals(aType)) {
                        String dependentComponents = this.mJac.listSharedLibraryDependents(aName, LIST_TARGET);
                        sLog.fine("ListBean.setSharedDepsTableData() dependentComponents=" + dependentComponents);
                        compInfoList = JBIComponentInfo.readFromXmlText((String)dependentComponents);
                    } else {
                        String requiredLibraries = this.mJac.listSharedLibraries(aName, LIST_TARGET);
                        sLog.fine("ListBean.setSharedDepsTableData() requiredLibraries=" + requiredLibraries);
                        compInfoList = JBIComponentInfo.readFromXmlText((String)requiredLibraries);
                    }
                } else {
                    sLog.fine("ListBean.setSharedDepsTableData() scaffolding false");
                }
            }
            this.mCachedDepsTableData = new ObjectListDataProvider(compInfoList);
        }
        catch (JBIRemoteException jbiRemoteEx) {
            sLog.fine("ListBean.setSharedDepsTableData(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
        }
        catch (Exception unexpectedEx) {
            this.logSevereI18n(unexpectedEx);
        }
    }
}

