/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.configuration.xml;

import com.sun.jbi.jsf.configuration.xml.model.Configuration;
import com.sun.jbi.jsf.configuration.xml.model.DisplayInformation;
import com.sun.jbi.jsf.util.JBILogger;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigurationParser
extends DefaultHandler
implements Serializable {
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private Configuration configuration = new Configuration();
    private String[] displayKeys;
    private DisplayInformation[] displayInfo = null;
    private static final String CONFIGURATION_KEY = "Configuration";
    private static final String DISPLAYNAME_KEY = "displayName";
    private static final String DISPLAYDESCRIPTION_KEY = "displayDescription";
    private static final String ISPASSWORDFIELD_KEY = "isPasswordField";
    private static final String NAME_KEY = "name";
    private static Logger sLog = JBILogger.getInstance();

    public ConfigurationParser(String[] keys) {
        this.displayKeys = new String[keys.length];
        this.displayInfo = new DisplayInformation[keys.length];
        for (int index = 0; index < keys.length; ++index) {
            this.displayKeys[index] = keys[index];
            this.displayInfo[index] = new DisplayInformation();
        }
    }

    public Configuration getComponentConfiguration() {
        return this.configuration;
    }

    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
    }

    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String displayName = null;
        String displayDescription = null;
        String password = null;
        boolean isPasswordField = false;
        if (qName.endsWith(CONFIGURATION_KEY)) {
            String name = attributes.getValue(NAME_KEY);
            this.configuration.setName(name);
        } else {
            for (int index = 0; index < this.displayKeys.length; ++index) {
                if (this.displayKeys[index] == null || !qName.endsWith(this.displayKeys[index])) continue;
                isPasswordField = false;
                displayName = attributes.getValue(DISPLAYNAME_KEY);
                displayDescription = attributes.getValue(DISPLAYDESCRIPTION_KEY);
                password = attributes.getValue(ISPASSWORDFIELD_KEY);
                if (displayName != null && displayDescription != null && password != null) {
                    isPasswordField = Boolean.parseBoolean(password);
                    sLog.fine("displayName:" + displayName + " displayDescription:" + displayDescription + " password:" + password + " isPasswordField:" + isPasswordField);
                    this.displayInfo[index] = new DisplayInformation(this.displayKeys[index], displayName, displayDescription, isPasswordField);
                    continue;
                }
                sLog.fine("displayName:" + displayName + " displayDescription:" + displayDescription + " password:" + password);
            }
        }
        this.qNameStack.push(qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if (!qName.endsWith(CONFIGURATION_KEY)) {
            for (int index = 0; index < this.displayKeys.length; ++index) {
                if (this.displayKeys[index] == null || !qName.endsWith(this.displayKeys[index])) continue;
                if (chars != null) {
                    this.displayInfo[index].setDefaultValue(chars);
                    continue;
                }
                this.displayInfo[index].setDefaultValue("");
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (qName.endsWith(CONFIGURATION_KEY)) {
            for (int index = 0; index < this.displayKeys.length; ++index) {
                if (this.displayKeys[index] != null && this.displayInfo[index] != null) {
                    this.configuration.addDisplayDetail(this.displayKeys[index], this.displayInfo[index]);
                    continue;
                }
                sLog.fine("Index " + index + " displayKeys or displayInfo is null.");
                if (this.displayKeys[index] != null) {
                    sLog.fine("displayKeys[" + index + "] is: " + this.displayKeys[index]);
                }
                if (this.displayInfo[index] == null) continue;
                sLog.fine("displayInfo[" + index + "] is: ");
                this.displayInfo[index].dump();
            }
        }
    }

    public static ConfigurationParser parse(String uriString, String[] keys) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        URI uri = new URI(uriString);
        InputStream inputStream = uri.toURL().openStream();
        InputSource inputSource = new InputSource(inputStream);
        ConfigurationParser parser = new ConfigurationParser(keys);
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser;
    }

    public static ConfigurationParser parseFromString(String xmlData, String[] keys) throws MalformedURLException, ParserConfigurationException, SAXException, URISyntaxException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlData.getBytes("UTF-8"));
        InputSource inputSource = new InputSource(inputStream);
        ConfigurationParser parser = new ConfigurationParser(keys);
        saxParser.parse(inputSource, (DefaultHandler)parser);
        return parser;
    }

    public static void main(String[] args) {
        String uri = "file:///C:/Alaska/jbicomps/cachese/jbiadapter/componentconfiguration.xml";
        String[] keys = null;
        String propertiesFile = "C:/Alaska/jbicomps/cachese/jbiadapter/config.properties";
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertiesFile));
        }
        catch (IOException e) {
            // empty catch block
        }
        keys = new String[properties.size()];
        Set<Map.Entry<Object, Object>> set = properties.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            keys[index] = (String)entry.getKey();
            ++index;
        }
        try {
            ConfigurationParser parser = ConfigurationParser.parse(uri, keys);
            parser.getComponentConfiguration().dump();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

