/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.factory;

import com.sun.jbi.jsf.factory.PropertySheetAdaptor;
import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.component.factory.ComponentFactoryBase;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.util.Util;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class DynamicPropertySheetFactory
extends ComponentFactoryBase {
    public static final String PROPERTY_SHEET_ADAPTOR_CLASS = "propertySheetAdaptorClass";

    public UIComponent create(FacesContext context, LayoutComponent descriptor, UIComponent parent) {
        PropertySheetAdaptor propertySheetAdaptor = this.getPropertySheetAdaptor(context, descriptor, parent);
        propertySheetAdaptor.init();
        String propertySheetId = propertySheetAdaptor.getId();
        return this.createPropertySheet(context, propertySheetAdaptor, propertySheetId, parent);
    }

    protected PropertySheetAdaptor getPropertySheetAdaptor(FacesContext ctx, LayoutComponent desc, UIComponent parent) {
        PropertySheetAdaptor adaptor = null;
        Object cls = desc.getEvaluatedOption(ctx, PROPERTY_SHEET_ADAPTOR_CLASS, parent);
        if (cls == null) {
            throw new IllegalArgumentException("'propertySheetAdaptorClass' must be specified!");
        }
        try {
            Class adaptorClass = Util.getClass((Object)cls);
            adaptor = (PropertySheetAdaptor)adaptorClass.getMethod("getInstance", FacesContext.class, LayoutComponent.class, UIComponent.class).invoke((Object)null, ctx, desc, parent);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        return adaptor;
    }

    protected UIComponent createPropertySheet(FacesContext ctx, PropertySheetAdaptor adaptor, String propertySheetId, UIComponent parent) {
        String id = adaptor.getId();
        String factoryClass = adaptor.getFactoryClass();
        Map<String, Object> props = adaptor.getFactoryOptions();
        Properties properties = Util.mapToProperties(props);
        UIComponent sheet = ComponentUtil.getChild((UIComponent)parent, (String)id, (String)factoryClass, (Properties)properties);
        sheet = adaptor.getPropertySheet(sheet);
        this.configurePropertySheet(ctx, adaptor, sheet, propertySheetId);
        parent.getChildren().add(sheet);
        return sheet;
    }

    protected void configurePropertySheet(FacesContext ctx, PropertySheetAdaptor adaptor, UIComponent propertySheet, Object currentObj) {
        Map<String, List<Handler>> handlersByType;
        Iterator<String> it;
        Map<String, UIComponent> facets = adaptor.getFacets(propertySheet, currentObj);
        if (facets != null) {
            Map propertySheetFacets = propertySheet.getFacets();
            it = facets.keySet().iterator();
            while (it.hasNext()) {
                String facetName = it.next();
                UIComponent facetValue = facets.get(facetName);
                if (facetValue == null) continue;
                propertySheetFacets.put(facetName, facetValue);
            }
        }
        if ((handlersByType = adaptor.getHandlersByType(propertySheet, currentObj)) != null && (it = handlersByType.keySet().iterator()).hasNext()) {
            String eventType = null;
            Map compAttrs = propertySheet.getAttributes();
            while (it.hasNext()) {
                eventType = it.next();
                compAttrs.put(eventType, handlersByType.get(eventType));
            }
        }
    }
}

