/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.common;

import com.sun.jbi.jsf.framework.model.JBIComponentStatus;
import com.sun.jbi.jsf.framework.model.JBIComponentStatusDocument;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentInformationParser
extends DefaultHandler
implements Serializable {
    private boolean parsingInProgress;
    private Stack<String> qNameStack = new Stack();
    private JBIComponentStatus component = null;
    private JBIComponentStatusDocument componentDoc = new JBIComponentStatusDocument();
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private Map componentInfoMap = new HashMap();

    public JBIComponentStatusDocument getDocument() {
        return this.componentDoc;
    }

    public void setDocument(JBIComponentStatusDocument jbiDocument) {
        this.componentDoc = jbiDocument;
    }

    public static JBIComponentStatusDocument parse(String documentString) throws IOException, SAXException, FileNotFoundException, ParserConfigurationException, SAXException {
        JBIComponentStatusDocument container = null;
        if (documentString == null) {
            return container;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        StringReader reader = new StringReader(documentString);
        InputSource inputSource = new InputSource(reader);
        ComponentInformationParser myEventHandler = new ComponentInformationParser();
        if (inputSource != null) {
            saxParser.parse(inputSource, (DefaultHandler)myEventHandler);
            container = myEventHandler.getDocument();
        }
        return container;
    }

    public static JBIComponentStatusDocument parse(File documentFile) throws IOException, SAXException, FileNotFoundException, ParserConfigurationException, SAXException {
        JBIComponentStatusDocument container = null;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        FileReader reader = new FileReader(documentFile);
        InputSource inputSource = new InputSource(reader);
        ComponentInformationParser myEventHandler = new ComponentInformationParser();
        saxParser.parse(inputSource, (DefaultHandler)myEventHandler);
        container = myEventHandler.getDocument();
        return container;
    }

    public void startDocument() throws SAXException {
        this.parsingInProgress = true;
        this.qNameStack.removeAllElements();
        this.componentDoc.getJbiComponentStatusList().clear();
    }

    public void endDocument() throws SAXException {
        this.parsingInProgress = false;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("component-info-list".equals(qName)) {
            String key = null;
            String value = null;
            for (int index = 0; index < attributes.getLength(); ++index) {
                key = attributes.getQName(index);
                if (key == null || (value = attributes.getValue(key)) == null) continue;
                this.namespaceMap.put(key, value);
            }
        } else if ("component-info".equals(qName)) {
            this.component = new JBIComponentStatus();
            String key = null;
            String value = null;
            for (int index = 0; index < attributes.getLength(); ++index) {
                key = attributes.getQName(index);
                if (key == null || (value = attributes.getValue(key)) == null) continue;
                if (key.equals("type")) {
                    this.component.setType(value);
                }
                if (key.equals("name")) {
                    this.component.setName(value);
                }
                if (!key.equals("state")) continue;
                this.component.setState(value);
            }
        }
        this.qNameStack.push(qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String chars = new String(ch, start, length);
        String qName = this.qNameStack.peek();
        if ("component-info-list".equals(qName)) {
            // empty if block
        }
        if ("component-info".equals(qName)) {
            // empty if block
        }
        if ("description".equals(qName) && this.component != null && chars != null) {
            this.component.setDescription(chars.trim());
        }
        if ("name".equals(qName) && this.component != null && chars != null) {
            this.component.setName(chars);
        }
        if ("state".equals(qName) && this.component != null && chars != null) {
            this.component.setState(chars);
        }
        if ("type".equals(qName) && this.component != null && chars != null) {
            this.component.setType(chars);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.qNameStack.pop();
        if (!"component-info-list".equals(qName) && "component-info".equals(qName)) {
            this.componentDoc.addJbiComponentStatus(this.component);
            this.component = null;
        }
    }

    public static void main(String[] args) {
    }
}

