/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.services.configuration.providers.glassfish;

import com.sun.jbi.jsf.framework.common.Util;
import com.sun.jbi.jsf.framework.connectors.ServerConnector;
import com.sun.jbi.jsf.framework.services.BaseServiceProvider;
import com.sun.jbi.jsf.framework.services.configuration.ConfigurationService;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SunConfigurationService
extends BaseServiceProvider
implements Serializable,
ConfigurationService {
    private Logger logger = Logger.getLogger(SunConfigurationService.class.getName());
    private static final String DOMAIN_NAME_PREFIX = "com.sun.ebi:";
    private static final String SERVICE_TYPE_PREFIX = "ServiceType=Configuration";
    private static final String INSTALLATION_TYPE_PREFIX = "InstallationType=";
    private static final String IDENTIFICATION_NAME_PREFIX = "IdentificationName=";
    private static final String IDENTIFICATION_SERVICE_UNIT = "ServiceUnitID=";
    private static final String SCHEMA_RETRIEVAL_OPERATION = "retrieveConfigurationDisplaySchema";
    private static final String DATA_RETRIEVAL_OPERATION = "retrieveConfigurationDisplayData";

    public SunConfigurationService(ServerConnector connector, String targetName) {
        super(connector, targetName);
    }

    @Override
    public Map<String, Object> getConfigurationProperties(String componentName, String componentType) {
        String name = this.getMBeanName(componentName, componentType);
        return this.getProperties(name);
    }

    @Override
    public void setConfigurationProperties(String componentName, String componentType, Map<String, Object> props) {
        String name = this.getMBeanName(componentName, componentType);
        this.setProperties(name, props);
    }

    @Override
    public Map<String, Object> getSUConfigurationProperties(String componentName, String componentType, String serviceUnitId) {
        String name = "com.sun.ebi:ServiceType=Configuration,InstallationType=" + Util.mapType(componentType) + "," + IDENTIFICATION_NAME_PREFIX + componentName + "," + IDENTIFICATION_SERVICE_UNIT + serviceUnitId;
        return this.getProperties(name);
    }

    private String getMBeanName(String componentName, String componentType) {
        String name = "com.sun.ebi:ServiceType=Configuration,InstallationType=" + Util.mapType(componentType) + "," + IDENTIFICATION_NAME_PREFIX + componentName;
        return name;
    }

    private Map<String, Object> getProperties(String mbeanName) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        try {
            ObjectName objectName = new ObjectName(mbeanName);
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                MBeanInfo mbeanInfo = this.serverConnection.getMBeanInfo(objectName);
                MBeanAttributeInfo[] attrs = mbeanInfo.getAttributes();
                for (int attrCount = 0; attrCount < attrs.length; ++attrCount) {
                    String attrName = attrs[attrCount].getName();
                    try {
                        Object value = this.serverConnection.getAttribute(objectName, attrName);
                        properties.put(attrName, value);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    @Override
    public void setProperties(String mbeanName, Map<String, Object> props) {
        try {
            ObjectName objectName = new ObjectName(mbeanName);
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                MBeanInfo mbeanInfo = this.serverConnection.getMBeanInfo(objectName);
                MBeanAttributeInfo[] attrs = mbeanInfo.getAttributes();
                for (int attrCount = 0; attrCount < attrs.length; ++attrCount) {
                    Object attrValue;
                    String attrType;
                    String attrName = attrs[attrCount].getName();
                    Attribute attr = this.createAttribute(attrName, attrType = attrs[attrCount].getType(), attrValue = props.get(attrName));
                    if (attr != null) {
                        try {
                            this.serverConnection.setAttribute(objectName, attr);
                        }
                        catch (Exception e) {
                            this.logger.warning("Attr:" + attrName + " value:" + attrValue + " cannot be set!");
                            e.printStackTrace();
                        }
                        continue;
                    }
                    this.logger.warning("Attr:" + attrName + " value:" + attrValue + " cannot be set!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Attribute createAttribute(String attrName, String attrType, Object attrValue) {
        Attribute attr = null;
        if (attrValue != null) {
            Object value = attrValue;
            try {
                value = "java.lang.Boolean".equals(attrType) ? new Boolean(attrValue.toString()) : ("java.lang.Integer".equals(attrType) ? (attrValue == null || attrValue.equals("") ? new Integer(0) : new Integer(attrValue.toString())) : ("java.lang.Long".equals(attrType) ? (attrValue == null || attrValue.equals("") ? new Long(0L) : new Long(attrValue.toString())) : ("java.lang.String".equals(attrType) ? new String(attrValue.toString()) : attrValue)));
                attr = new Attribute(attrName, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return attr;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public Object getProperty(String name) {
        return "";
    }

    @Override
    public String getSchema(String componentName, String componentType) {
        String schema = null;
        try {
            String mbeanName = this.getMBeanName(componentName, componentType);
            ObjectName objectName = new ObjectName(mbeanName);
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                schema = (String)this.serverConnection.invoke(objectName, SCHEMA_RETRIEVAL_OPERATION, null, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return schema;
    }

    @Override
    public String getXmlData(String componentName, String componentType) {
        String xmlData = null;
        try {
            String mbeanName = this.getMBeanName(componentName, componentType);
            ObjectName objectName = new ObjectName(mbeanName);
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                xmlData = (String)this.serverConnection.invoke(objectName, DATA_RETRIEVAL_OPERATION, null, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return xmlData;
    }

    @Override
    public String[] getAttributeNames(String componentName, String componentType) {
        String[] attrNames = null;
        try {
            String mbeanName = this.getMBeanName(componentName, componentType);
            ObjectName objectName = new ObjectName(mbeanName);
            if (this.serverConnection != null && this.serverConnection.isRegistered(objectName)) {
                MBeanInfo mbeanInfo = this.serverConnection.getMBeanInfo(objectName);
                MBeanAttributeInfo[] attrs = mbeanInfo.getAttributes();
                attrNames = new String[attrs.length];
                for (int attrCount = 0; attrCount < attrs.length; ++attrCount) {
                    attrNames[attrCount] = attrs[attrCount].getName();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return attrNames;
    }
}

