/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.handlers;

import com.sun.jbi.jsf.bean.SelectableServiceUnitInfo;
import com.sun.jbi.jsf.bean.ServiceUnitBean;
import com.sun.jbi.jsf.util.BeanUtilities;
import com.sun.jbi.jsf.util.JBILogger;
import com.sun.jbi.ui.common.JBIAdminCommands;
import com.sun.jbi.ui.common.JBIRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import com.sun.jbi.ui.common.ServiceUnitInfo;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ServiceUnitHandlers {
    public static final String TBL_PAGE_TYPE_BINDINGS_ENGINES = "bindingsEngines";
    public static final String TBL_PAGE_TYPE_DEPLOYMENTS = "deployments";
    public static final String TBL_PAGE_TYPE_LIBRARIES = "libraries";
    private static Logger sLog = JBILogger.getInstance();

    private static SelectableServiceUnitInfo createSelectableServiceUnitInfo(ServiceUnitInfo aServiceUnitInfo, String aSaName, String aTarget) {
        String suName = aServiceUnitInfo.getName();
        String suDesc = aServiceUnitInfo.getDescription();
        String suTgt = aServiceUnitInfo.getTargetName();
        String suState = aServiceUnitInfo.getState();
        SelectableServiceUnitInfo selectableServiceUnit = new SelectableServiceUnitInfo(suName, suDesc, suTgt, suState, aSaName);
        String compType = BeanUtilities.getComponentType(suTgt, aTarget);
        selectableServiceUnit.setComponentType(compType);
        return selectableServiceUnit;
    }

    public static void jbiSetServiceUnitInfo(HandlerContext handlerCtx) {
        ServiceUnitBean serviceUnitBean;
        String description;
        block5: {
            String serviceUnitName = (String)handlerCtx.getInputValue("serviceUnitName");
            String serviceAssemblyName = (String)handlerCtx.getInputValue("serviceAssemblyName");
            String componentType = (String)handlerCtx.getInputValue("componentType");
            String targetComponent = (String)handlerCtx.getInputValue("targetComponent");
            description = "";
            boolean done = false;
            sLog.fine("QueryHandlers.jbiGetServiceUnitInfo(...), serviceUnitName=" + serviceUnitName);
            serviceUnitBean = BeanUtilities.getServiceUnitBean();
            serviceUnitBean.setName(serviceUnitName);
            serviceUnitBean.setServiceAssemblyName(serviceAssemblyName);
            serviceUnitBean.setComponentType(componentType);
            serviceUnitBean.setTargetComponent(targetComponent);
            try {
                JBIAdminCommands mJac = BeanUtilities.getClient();
                String xml = mJac.listServiceAssemblies(targetComponent, "server");
                List saInfoList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)xml);
                if (saInfoList == null) break block5;
                for (Object saInfoObject : saInfoList) {
                    String saName = ((ServiceAssemblyInfo)saInfoObject).getName();
                    if (serviceAssemblyName.equals(saName)) {
                        List infoList = ((ServiceAssemblyInfo)saInfoObject).getServiceUnitInfoList();
                        for (Object suInfoObject : infoList) {
                            String suName = ((ServiceUnitInfo)suInfoObject).getName();
                            if (!suName.equals(serviceUnitName)) continue;
                            done = true;
                            description = ((ServiceUnitInfo)suInfoObject).getDescription();
                        }
                    }
                    if (!done) continue;
                    break;
                }
            }
            catch (JBIRemoteException jbiRemoteEx) {
                sLog.fine("QueryHandlers.jbiSetServiceUnitInfo(): caught jbiRemoteEx=" + (Object)((Object)jbiRemoteEx));
            }
        }
        serviceUnitBean.setDescription(description);
    }

    /*
     * Unable to fully structure code
     */
    public static void jbiInitServieAssemblyServiceUnitsList(HandlerContext handlerCtx) {
        pageType = (String)handlerCtx.getInputValue("pageType");
        name = (String)handlerCtx.getInputValue("name");
        target = (String)handlerCtx.getInputValue("target");
        listBean = BeanUtilities.getListBean();
        serviceUnitBean = BeanUtilities.getServiceUnitBean();
        filteredServiceUnitList = new ArrayList<SelectableServiceUnitInfo>();
        saName = "";
        xmlQueryResults = listBean.getListServiceAssemblies();
        if (pageType.equals("deployments")) {
            saInfoList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)xmlQueryResults);
            if (saInfoList != null) {
                for (E saInfoObject : saInfoList) {
                    saName = ((ServiceAssemblyInfo)saInfoObject).getName();
                    if (!name.equals(saName)) continue;
                    infoList = ((ServiceAssemblyInfo)saInfoObject).getServiceUnitInfoList();
                    for (E suInfoObject : infoList) {
                        selectableServiceUnit = ServiceUnitHandlers.createSelectableServiceUnitInfo((ServiceUnitInfo)suInfoObject, saName, target);
                        selectableServiceUnit.setQueryString("sa");
                        filteredServiceUnitList.add(selectableServiceUnit);
                    }
                    break;
                }
            }
        } else if (pageType.equals("bindingsEngines")) {
            try {
                mJac = BeanUtilities.getClient();
                xml = mJac.listServiceAssemblies(name, target);
                saInfoList = ServiceAssemblyInfo.readFromXmlTextWithProlog((String)xml);
                if (saInfoList == null) ** GOTO lbl46
                for (E saInfoObject : saInfoList) {
                    infoList = ((ServiceAssemblyInfo)saInfoObject).getServiceUnitInfoList();
                    saName = ((ServiceAssemblyInfo)saInfoObject).getName();
                    for (E suInfoObject : infoList) {
                        tgtName = ((ServiceUnitInfo)suInfoObject).getTargetName();
                        if (!tgtName.equals(name)) continue;
                        selectableServiceUnit = ServiceUnitHandlers.createSelectableServiceUnitInfo((ServiceUnitInfo)suInfoObject, saName, target);
                        selectableServiceUnit.setQueryString("comp");
                        filteredServiceUnitList.add(selectableServiceUnit);
                    }
                }
            }
            catch (JBIRemoteException jbiRemoteEx) {
                ServiceUnitHandlers.sLog.fine("QueryHandlers.jbiInitServieAssemblyServiceUnitsList(): caught jbiRemoteEx=" + (Object)jbiRemoteEx);
            }
        }
        serviceUnitBean.setServiceUnitsList(filteredServiceUnitList);
    }
}

