/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.endpointMeter;

import java.util.Enumeration;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.impl.endpoint.endpointMeter.PropagationMeter;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class PropagationMetric
implements DocumentSerializable {
    private String serviceName;
    private String serviceParameter;
    private String serviceIdString;
    int numPropagations;
    int numPropagatedTo;
    int numFilteredOut;
    int numErrorsPropagated;
    long propagationTime;

    public PropagationMetric() {
        this.serviceIdString = this.serviceName + this.serviceParameter;
    }

    public PropagationMetric(PropagationMeter propagationMeter) {
        this.serviceName = propagationMeter.getServiceName();
        this.serviceParameter = propagationMeter.getServiceParameter();
        this.serviceIdString = this.serviceName + this.serviceParameter;
    }

    public PropagationMetric(PropagationMetric prototype) {
        this.serviceName = prototype.getServiceName();
        this.serviceParameter = prototype.getServiceParameter();
        this.serviceIdString = this.serviceName + this.serviceParameter;
    }

    void registerPropagateMessageStats(int numPropagatedTo, int numFilteredOut, int numErrorsPropagated, long propagationTime) {
        ++this.numPropagations;
        this.numPropagatedTo += numPropagatedTo;
        this.numFilteredOut += numFilteredOut;
        this.numErrorsPropagated += numErrorsPropagated;
        this.propagationTime += propagationTime;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceParameter() {
        return this.serviceParameter;
    }

    public int getNumPropagations() {
        return this.numPropagations;
    }

    public int getNumPropagatedTo() {
        return this.numPropagatedTo;
    }

    public int getAverageNumTransports() {
        return this.numPropagatedTo == 0 ? 0 : this.numPropagations / this.numPropagatedTo;
    }

    public int getNumFilteredOut() {
        return this.numFilteredOut;
    }

    public int getNumErrorsPropagated() {
        return this.numErrorsPropagated;
    }

    public long getPropagationTime() {
        return this.propagationTime;
    }

    public long getAveragePropagationTime() {
        return this.numPropagatedTo == 0 ? 0L : this.propagationTime / (long)this.numPropagatedTo;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropagationMetric) {
            PropagationMetric other = (PropagationMetric)obj;
            return this.serviceIdString.equals(other.serviceIdString);
        }
        return false;
    }

    public boolean matches(String serviceName, String serviceParam) {
        if (serviceName.equals(this.getServiceName())) {
            if (serviceParam == null && this.getServiceParameter() == null) {
                return true;
            }
            if (serviceParam != null && this.getServiceParameter() != null) {
                return serviceParam.equals(this.getServiceParameter());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.serviceIdString.hashCode();
    }

    String getServiceIdString() {
        return this.serviceIdString;
    }

    public void mergeMetrics(PropagationMetric other) {
        this.numPropagatedTo += other.numPropagatedTo;
        this.numFilteredOut += other.numFilteredOut;
        this.numErrorsPropagated += other.numErrorsPropagated;
        this.propagationTime += other.propagationTime;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addString(element2, "serviceName", this.serviceName);
        DocumentSerializableUtilities.addString(element2, "serviceParam", this.serviceParameter);
        if (this.numPropagations != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPropagations", this.numPropagatedTo);
        }
        if (this.numPropagatedTo != 0) {
            DocumentSerializableUtilities.addInt(element2, "numPropagatedTo", this.numPropagatedTo);
        }
        if (this.numFilteredOut != 0) {
            DocumentSerializableUtilities.addInt(element2, "numFilteredOut", this.numFilteredOut);
        }
        if (this.numErrorsPropagated != 0) {
            DocumentSerializableUtilities.addInt(element2, "numErrorsPropagated", this.numErrorsPropagated);
        }
        if (this.propagationTime != 0L) {
            DocumentSerializableUtilities.addLong(element2, "propagationTime", this.propagationTime);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("serviceName")) {
                this.serviceName = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("serviceParam")) {
                this.serviceParameter = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("numPropagations")) {
                this.numPropagations = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numPropagatedTo")) {
                this.numPropagatedTo = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("numFilteredOut")) {
                this.numFilteredOut = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("propagationTime")) {
                this.propagationTime = DocumentSerializableUtilities.getLong(childElement);
                continue;
            }
            if (!tagName.equals("numErrorsPropagated")) continue;
            this.numErrorsPropagated = DocumentSerializableUtilities.getInt(childElement);
        }
        this.serviceIdString = this.serviceName + this.serviceParameter;
    }
}

