/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.util.pipe.reliable;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.endpoint.Message;
import net.jxta.impl.util.pipe.reliable.Incoming;
import net.jxta.logging.Logging;
import net.jxta.pipe.InputPipe;

public class IncomingPipeAdaptor
implements Runnable {
    private static final Logger LOG = Logger.getLogger(IncomingPipeAdaptor.class.getName());
    private InputPipe pipe = null;
    private Incoming incoming = null;
    private Thread poller = null;

    public IncomingPipeAdaptor(InputPipe pipe, Incoming incoming) {
        if (pipe == null) {
            throw new IllegalArgumentException("pipe cannot be null");
        }
        this.pipe = pipe;
        if (incoming == null) {
            throw new IllegalArgumentException("incoming cannot be null");
        }
        this.incoming = incoming;
        this.poller = new Thread((Runnable)this, "Reliable IncomingPipe Message Poll Thread");
        this.poller.setDaemon(true);
        this.poller.start();
    }

    public void run() {
        try {
            while (true) {
                Message msg = null;
                try {
                    msg = this.pipe.waitForMessage();
                }
                catch (InterruptedException ignore) {
                    continue;
                }
                if (msg == null) continue;
                this.incoming.recv(msg);
            }
        }
        catch (Throwable all) {
            if (Logging.SHOW_WARNING && LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "Uncaught Throwable in thread :" + Thread.currentThread().getName(), all);
            }
            return;
        }
    }
}

