/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.peer.PeerID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SrdiMessage {
    public static final int PERSISTONLY = 0;
    public static final int REPLICATE = 1;
    private final Collection<Entry> entries = new HashSet<Entry>();
    private PeerID peerid = null;
    private String primaryKey = null;
    private int scope = 0;

    public abstract Document getDocument(MimeMediaType var1);

    public PeerID getPeerID() {
        return this.peerid;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    @Deprecated
    public int getTTL() {
        return this.scope;
    }

    @Deprecated
    public void setTTL(int newTTL) {
        this.scope = newTTL;
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public void decrementTTL() {
        if (this.scope > 0) {
            --this.scope;
        }
    }

    public Collection<Entry> getEntries() {
        return new ArrayList<Entry>(this.entries);
    }

    public void addEntry(String key, String value, long expiration) {
        this.addEntry(new Entry(key, value, expiration));
    }

    public void addEntry(Entry entry) {
        this.entries.add(entry);
    }

    public void setEntries(Collection<Entry> newEntries) {
        this.entries.clear();
        this.entries.addAll(newEntries);
    }

    public void setPeerID(PeerID peerid) {
        this.peerid = peerid;
    }

    public void setPrimaryKey(String pkey) {
        this.primaryKey = pkey;
    }

    public static String getMessageType() {
        return "jxta:GenSRDI";
    }

    public static final class Entry {
        public long expiration;
        public String key;
        public String value;

        public boolean equals(Object target) {
            if (this == target) {
                return true;
            }
            if (target instanceof Entry) {
                Entry likeMe = (Entry)target;
                return this.key.equals(likeMe.key) && this.value.equals(likeMe.value);
            }
            return false;
        }

        public int hashCode() {
            int result = 0;
            if (null != this.key) {
                result ^= this.key.hashCode();
            }
            if (null != this.value) {
                result ^= this.value.hashCode();
            }
            return result;
        }

        public Entry(String key, String value, long expiration) {
            this.key = key;
            this.value = value;
            this.expiration = expiration;
        }
    }
}

