/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.clientreg;

import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxServiceUrlFactory;
import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.ConfigurationException;

public abstract class JMXConnectorRegistry {
    private static final int TIME_BETWEEN_RECONNECTS_IN_MS = 0;
    static final String PKGS = "com.sun.enterprise.admin.jmx.remote.protocol";
    private static final boolean DEBUG = Boolean.getBoolean("Debug");
    private HashMap _registry = new HashMap();
    private static Logger _logger = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected JMXConnectorRegistry() {
    }

    protected abstract MBeanServerConnectionInfo findConnectionInfo(String var1) throws AgentException;

    public static boolean isMBeanServerUnreachable(Throwable ex) {
        for (Throwable t = ex; t != null; t = t.getCause()) {
            if (t instanceof ConnectException) {
                return true;
            }
            if (t instanceof InstanceNotFoundException) {
                JMXConnectorRegistry.getLogger().log(Level.WARNING, "registry.potentialPortConflict", ex.toString());
                return true;
            }
            if (!JMXConnectorRegistry.isUnknownHostException(t)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUnknownHostException(Throwable t) {
        ConfigurationException cex;
        Throwable root;
        if (t instanceof ConfigurationException && (root = (cex = (ConfigurationException)t).getCause()) != null) {
            if (root instanceof UnknownHostException) {
                return true;
            }
            if (root instanceof java.rmi.UnknownHostException) {
                return true;
            }
        }
        return false;
    }

    protected void removeConnectorFromCache(String name) throws IOException {
        this.disconnectCachedConnector(name);
        this._registry.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnectCachedConnector(String name) throws IOException {
        MBeanServerConnectionInfo connectionInfo = (MBeanServerConnectionInfo)this._registry.get(name);
        Serializable monitor = connectionInfo;
        if (monitor == null) {
            monitor = this._registry;
        }
        MBeanServerConnectionInfo mBeanServerConnectionInfo = monitor;
        synchronized (mBeanServerConnectionInfo) {
            if (connectionInfo != null && connectionInfo.isConnected()) {
                JMXConnector conn = connectionInfo.getJMXConnector();
                if (conn != null) {
                    conn.close();
                }
                connectionInfo.setJMXConnector(null);
            }
        }
    }

    private MBeanServerConnectionInfo connect(MBeanServerConnectionInfo connectionInfo, String name) throws AgentException, IOException {
        long currentTime = 0L;
        if (connectionInfo == null) {
            connectionInfo = this.findConnectionInfo(name);
            connectionInfo.setLastConnectTime(currentTime);
            this._registry.put(name, connectionInfo);
            connectionInfo.setJMXConnector(this.connect(connectionInfo));
        } else {
            long lastConnectTime = connectionInfo.getLastConnectTime();
            if (DEBUG) {
                System.out.println("attempting to connect to " + name);
            }
            MBeanServerConnectionInfo newConnectionInfo = this.findConnectionInfo(name);
            connectionInfo.setLastConnectTime(currentTime);
            connectionInfo.setJMXConnector(this.connect(newConnectionInfo));
        }
        return connectionInfo;
    }

    protected boolean connectionIsValid(MBeanServerConnectionInfo connectionInfo, String name) {
        if (DEBUG) {
            System.out.println("JMXConnectorRegistry:Reusing connected connection to " + name);
        }
        if (!connectionInfo.isConnected()) {
            return false;
        }
        long timeout = 15000L;
        return JMXConnectorRegistry.connectionIsValidTimeout(connectionInfo, name, 15000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanServerConnection getConnection(String name) throws AgentException {
        try {
            MBeanServerConnectionInfo connectionInfo;
            Serializable monitor = connectionInfo = (MBeanServerConnectionInfo)this._registry.get(name);
            if (monitor == null) {
                monitor = this._registry;
            }
            MBeanServerConnectionInfo mBeanServerConnectionInfo = monitor;
            synchronized (mBeanServerConnectionInfo) {
                if (connectionInfo == null) {
                    if (DEBUG) {
                        System.out.println("JMXConnectorRegistry:Establishing new connection to " + name);
                    }
                    connectionInfo = this.connect(connectionInfo, name);
                } else if (!connectionInfo.isConnected()) {
                    if (DEBUG) {
                        System.out.println("JMXConnectorRegistry:Reusing unconnected connection to " + name);
                    }
                    connectionInfo = this.connect(connectionInfo, name);
                } else if (!this.connectionIsValid(connectionInfo, name)) {
                    if (DEBUG) {
                        System.out.println("JMXConnectorRegistry:Reusing invalid connection to " + name);
                    }
                    connectionInfo.setJMXConnector(null);
                    connectionInfo = this.connect(connectionInfo, name);
                }
                if (!connectionInfo.isConnected()) {
                    throw new ConnectException("0 ms have not elapsed since last connection attempt to " + name);
                }
                if (DEBUG) {
                    System.out.println("Connection to " + name + " succeeded");
                }
                return connectionInfo.getMBeanServerConnection();
            }
        }
        catch (AgentException ex) {
            if (DEBUG) {
                System.out.println("Connection to " + name + " failed " + (Object)((Object)ex));
            }
            throw ex;
        }
        catch (Exception ex) {
            if (DEBUG) {
                System.out.println("Connection to " + name + " failed " + ex);
            }
            throw new AgentException(ex);
        }
    }

    protected JMXConnector connect(MBeanServerConnectionInfo connectionInfo) throws IOException {
        JMXServiceURL url = null;
        try {
            url = JmxServiceUrlFactory.forRmiWithJndiInAppserver((String)connectionInfo.getHost(), (int)Integer.parseInt(connectionInfo.getPort()));
        }
        catch (NumberFormatException e) {
            throw new IOException(e.getMessage());
        }
        if (DEBUG) {
            System.out.println("Attempting to connect to mbean server at " + url);
        }
        return JMXConnectorRegistry.connectToServer(url, connectionInfo.getUser(), connectionInfo.getPassword());
    }

    public static JMXConnector connectToServer(JMXServiceURL url, String user, String password) throws IOException {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.protocol.provider.pkgs", PKGS);
        env.put("jmx.remote.credentials", new String[]{user, password});
        env.put("USER", user);
        env.put("PASSWORD", password);
        env.put("com.sun.enterprise.as.http.auth", "BASIC");
        JMXConnector conn = JMXConnectorFactory.connect(url, env);
        return conn;
    }

    public static MBeanServerConnection connect(JMXServiceURL url, String user, String password) throws IOException {
        JMXConnector conn = JMXConnectorRegistry.connectToServer(url, user, password);
        return conn.getMBeanServerConnection();
    }

    private static boolean connectionIsValidTimeout(MBeanServerConnectionInfo connectionInfo, String name, long tom) {
        boolean valid = false;
        try {
            RudimentaryThreadState ts = new RudimentaryThreadState();
            Thread cvt = JMXConnectorRegistry.createTask("ConnectionValidatorTask: " + name, connectionInfo, ts);
            cvt.start();
            cvt.join(tom);
            if (cvt.isAlive()) {
                try {
                    JMXConnectorRegistry.logFineValidMessage(connectionInfo, tom);
                    cvt.interrupt();
                }
                catch (Exception ee) {}
            } else if (ts.isRunSuccessful()) {
                valid = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            valid = false;
        }
        return valid;
    }

    private static Thread createTask(String name, MBeanServerConnectionInfo ci, RudimentaryThreadState ts) {
        return new CVTask(name, ci, ts);
    }

    private static void logFineValidMessage(MBeanServerConnectionInfo ci, long tom) {
        Logger lg = Logger.getLogger("javax.enterprise.system.tools.admin");
        if (lg.isLoggable(Level.FINE)) {
            String msg = "Cached Connection: " + ci + " times out after: " + tom + " milliseconds and it is not valid anymore. This should not " + "be a problem as an attempt will be made to establish a new connection";
            lg.fine(msg);
        }
    }

    private static class CVTask
    extends Thread {
        private MBeanServerConnectionInfo ci;
        private final RudimentaryThreadState ts;

        CVTask(String name, MBeanServerConnectionInfo ci, RudimentaryThreadState ts) {
            super(name);
            this.ci = ci;
            this.ts = ts;
        }

        public void run() {
            try {
                this.ci.getMBeanServerConnection().getDefaultDomain();
            }
            catch (Exception e) {
                this.ts.runMethodThrewException();
            }
        }
    }

    private static class RudimentaryThreadState {
        private boolean runMethodRanSuccessfully = true;

        RudimentaryThreadState() {
        }

        void runMethodThrewException() {
            this.runMethodRanSuccessfully = false;
        }

        boolean isRunSuccessful() {
            return this.runMethodRanSuccessfully;
        }
    }
}

