/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.hadbmgmt;

import com.sun.enterprise.ee.admin.hadbmgmt.Constants;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBInfo;
import com.sun.enterprise.ee.admin.hadbmgmt.HADBMExecutor;
import com.sun.enterprise.ee.admin.hadbmgmt.LoggerHelper;
import java.util.StringTokenizer;

class HADBVersion {
    private int a;
    private int b;
    private int c;
    private int d;

    HADBVersion(HADBInfo info) {
        try {
            String[] commands = new String[]{"--version"};
            HADBMExecutor exec = new HADBMExecutor(info.getExecutable(), commands);
            int exitValue = exec.exec();
            if (exitValue == 0) {
                String ver = this.parse(exec.getStdout());
                this.set(ver);
                LoggerHelper.fine("hadbmgmt-res.Version", ver);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.set("");
    }

    public String toString() {
        return "" + this.a + '.' + this.b + '.' + this.c + '.' + this.d;
    }

    double getMajor() {
        try {
            return Double.parseDouble("" + this.a + "." + this.b);
        }
        catch (Exception e) {
            return 4.5;
        }
    }

    double getMinor() {
        try {
            return Double.parseDouble("" + this.c + "." + this.d);
        }
        catch (Exception e) {
            return 0.2;
        }
    }

    int getA() {
        return this.a;
    }

    int getB() {
        return this.b;
    }

    int getC() {
        return this.c;
    }

    int getD() {
        return this.d;
    }

    private void set(String hadbroot) {
        if (hadbroot.length() == 7) {
            try {
                this.a = Integer.parseInt(hadbroot.substring(0, 1));
                this.b = Integer.parseInt(hadbroot.substring(2, 3));
                this.c = Integer.parseInt(hadbroot.substring(4, 5));
                this.d = Integer.parseInt(hadbroot.substring(6, 7));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setDefault();
    }

    private void setDefault() {
        this.a = Constants.DEFAULT_HADB_VERSION[0];
        this.b = Constants.DEFAULT_HADB_VERSION[1];
        this.c = Constants.DEFAULT_HADB_VERSION[2];
        this.d = Constants.DEFAULT_HADB_VERSION[3];
        LoggerHelper.warning("hadbmgmt-res.NoVersion", this);
    }

    private String parse(String s) {
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens() && !st.nextToken().equals("Version")) {
        }
        while (st.hasMoreTokens() && !st.nextToken().equals(":")) {
        }
        if (st.hasMoreTokens()) {
            return st.nextToken();
        }
        return "";
    }
}

