/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.pluggable;

import com.sun.enterprise.admin.monitor.stats.lb.LoadBalancerStats;
import com.sun.enterprise.admin.monitor.stats.lb.LoadBalancerStatsInterface;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.LoadBalancer;
import com.sun.enterprise.config.serverbeans.LoadBalancers;
import com.sun.enterprise.ee.admin.lbadmin.mbeans.HTTPLBAdminConfigMBean;
import com.sun.enterprise.ee.admin.lbadmin.monitor.LbMonitoringHelper;
import com.sun.enterprise.ee.admin.lbadmin.writer.LbConfigExporter;
import com.sun.enterprise.ee.admin.lbadmin.writer.LbConfigPublisher;
import com.sun.enterprise.server.pluggable.LBFeatureFactory;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EELBFeatureFactoryImpl
implements LBFeatureFactory {
    private static final StringManager _strMgr = StringManager.getManager(HTTPLBAdminConfigMBean.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
    private static final StringManagerBase _sMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());

    public void applyChanges(String configName) {
        _logger.log(Level.FINE, "[LBAdminMBean] applyChanges called - LB Config " + configName);
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            LoadBalancers loadbalancers = ((Domain)ctx.getRootConfigBean()).getLoadBalancers();
            if (loadbalancers == null) {
                throw new Exception(_strMgr.getString("NoLoadbalancersConfigured"));
            }
            LoadBalancer[] lbs = loadbalancers.getLoadBalancer();
            if (lbs == null) {
                throw new Exception(_strMgr.getString("NoLoadbalancersConfigured"));
            }
            for (LoadBalancer lb : lbs) {
                if (lb == null) {
                    throw new Exception(_strMgr.getString("NoLoadbalancersConfigured"));
                }
                if (!lb.getLbConfigName().equals(configName)) continue;
                LbConfigPublisher lbp = new LbConfigPublisher(ctx, configName, lb.getName());
                lbp.publish();
                _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ApplyChanges", (Object)lb.getName()));
            }
        }
        catch (Exception e) {
            String msg = _strMgr.getString("LbApplyChangesFailed", (Object)configName, (Object)e.getMessage());
            _logger.log(Level.WARNING, msg);
        }
    }

    public void applyChanges(String configName, String lbName) {
        if (lbName == null || lbName.equals("") || lbName.equals("null")) {
            this.applyChanges(configName);
            return;
        }
        _logger.log(Level.FINE, "[LBAdminMBean] exportLbConfig called - LB Config " + configName + " " + lbName);
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            if (configName == null || configName.equals("") || configName.equals("null")) {
                LoadBalancers lbs = ((Domain)ctx.getRootConfigBean()).getLoadBalancers();
                if (lbs == null) {
                    throw new Exception(_strMgr.getString("NoLoadbalancersConfigured"));
                }
                LoadBalancer lb = lbs.getLoadBalancerByName(lbName);
                if (lb == null) {
                    throw new Exception(_strMgr.getString("LbDoesNotExist", (Object)lbName));
                }
                configName = lb.getLbConfigName();
            }
            LbConfigPublisher lbp = new LbConfigPublisher(ctx, configName, lbName);
            lbp.publish();
            _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ApplyChanges", (Object)lbName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isApplyChangeRequired(String lbConfigName, String lbName) {
        return true;
    }

    public String getLoadBalancerXML(String configName, String lbName) {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            if (configName == null || configName.equals("") || configName.equals("null")) {
                LoadBalancers lbs = ((Domain)ctx.getRootConfigBean()).getLoadBalancers();
                if (lbs == null) {
                    throw new Exception(_strMgr.getString("NoLoadbalancersConfigured"));
                }
                LoadBalancer lb = lbs.getLoadBalancerByName(lbName);
                if (lb == null) {
                    throw new Exception(_strMgr.getString("LbDoesNotExist", (Object)lbName));
                }
                configName = lb.getLbConfigName();
            }
            String xml = LbConfigExporter.getXML(ctx, configName);
            _logger.log(Level.FINE, _sMgr.getString("http_lb_admin.GetLBXml", (Object)lbName));
            return xml;
        }
        catch (Exception e) {
            String msg = _strMgr.getString("LbGetXMLFailed", (Object)lbName, (Object)e.getMessage());
            _logger.log(Level.WARNING, msg);
            return "";
        }
    }

    public LoadBalancerStatsInterface getLoadBalancerMonitoringStats(String configName, String lbName) {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            if (configName == null || configName.equals("") || configName.equals("null")) {
                LoadBalancers lbs = ((Domain)ctx.getRootConfigBean()).getLoadBalancers();
                if (lbs == null) {
                    throw new Exception(_strMgr.getString("NoLoadbalancersConfigured"));
                }
                LoadBalancer lb = lbs.getLoadBalancerByName(lbName);
                if (lb == null) {
                    throw new Exception(_strMgr.getString("LbDoesNotExist", (Object)lbName));
                }
                configName = lb.getLbConfigName();
            } else if (lbName == null) {
                // empty if block
            }
            LbMonitoringHelper lbMonitoringHelper = new LbMonitoringHelper(ctx, configName, lbName);
            String xml = lbMonitoringHelper.getMonitoringXml();
            LoadBalancerStats lbstats = LoadBalancerStats.readNoEntityResolver((InputStream)new ByteArrayInputStream(xml.getBytes()));
            _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.GetStats", (Object)lbName));
            return lbstats;
        }
        catch (Exception e) {
            String msg = _strMgr.getString("LbGetStatsFailed", (Object)configName, (Object)lbName);
            _logger.log(Level.WARNING, msg);
            return null;
        }
    }

    public boolean testConnection(String configName, String lbName) {
        boolean result = false;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            if (configName == null || configName.equals("") || configName.equals("null")) {
                LoadBalancers lbs = ((Domain)ctx.getRootConfigBean()).getLoadBalancers();
                if (lbs == null) {
                    throw new Exception(_strMgr.getString("NoLoadbalancersConfigured"));
                }
                LoadBalancer lb = lbs.getLoadBalancerByName(lbName);
                if (lb == null) {
                    throw new Exception(_strMgr.getString("LbDoesNotExist", (Object)lbName));
                }
                configName = lb.getLbConfigName();
            }
            LbConfigPublisher lbp = new LbConfigPublisher(ctx, configName, lbName);
            result = lbp.ping();
            _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.TestConnection", (Object)Boolean.toString(result), (Object)lbName));
        }
        catch (Exception e) {
            String msg = _strMgr.getString("LbTestConnectionFailed", (Object)lbName);
            _logger.log(Level.WARNING, msg);
        }
        return result;
    }

    public void resetStats(String configName, String lbName) {
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            if (configName == null || configName.equals("") || configName.equals("null")) {
                LoadBalancers lbs = ((Domain)ctx.getRootConfigBean()).getLoadBalancers();
                if (lbs == null) {
                    throw new Exception(_strMgr.getString("NoLoadbalancersConfigured"));
                }
                LoadBalancer lb = lbs.getLoadBalancerByName(lbName);
                if (lb == null) {
                    throw new Exception(_strMgr.getString("LbDoesNotExist", (Object)lbName));
                }
                configName = lb.getLbConfigName();
            }
            LbMonitoringHelper lbMonitoringHelper = new LbMonitoringHelper(ctx, configName, lbName);
            lbMonitoringHelper.reset();
            _logger.log(Level.INFO, _sMgr.getString("http_lb_admin.ResetStats", (Object)lbName));
        }
        catch (Exception e) {
            String msg = _strMgr.getString("LbResetStatsFailed", (Object)lbName);
            _logger.log(Level.WARNING, msg);
            throw new RuntimeException(e);
        }
    }
}

