/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.reader.impl;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.ClusterRef;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.LbConfig;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.ClusterReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LbReaderException;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LoadbalancerReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.PropertyReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.ClusterReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.PropertyReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.reader.impl.StandAloneClusterReaderImpl;
import com.sun.enterprise.ee.admin.lbadmin.transform.LoadbalancerVisitor;
import com.sun.enterprise.ee.admin.lbadmin.transform.Visitor;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;

public class LoadbalancerReaderImpl
implements LoadbalancerReader {
    LbConfig _lbConfig = null;
    ConfigContext _ctx = null;
    private static final StringManager _localStrMgr = StringManager.getManager(LoadbalancerReaderImpl.class);

    public LoadbalancerReaderImpl(ConfigContext ctx, LbConfig lbConfig) {
        if (lbConfig == null || ctx == null) {
            String msg = _localStrMgr.getString("ConfigBeanAndNameNull");
            throw new IllegalArgumentException(msg);
        }
        this._ctx = ctx;
        this._lbConfig = lbConfig;
    }

    public PropertyReader[] getProperties() throws LbReaderException {
        ElementProperty[] properties = this._lbConfig.getElementProperty();
        PropertyReaderImpl activeHealth = null;
        PropertyReaderImpl numHealth = null;
        PropertyReaderImpl rewriteLoc = null;
        int propSize = properties.length;
        if (this._lbConfig.getElementPropertyByName("active-healthcheck-enabled") == null) {
            activeHealth = new PropertyReaderImpl(this._lbConfig, "active-healthcheck-enabled", "false");
            ++propSize;
        }
        if (this._lbConfig.getElementPropertyByName("number-healthcheck-retries") == null) {
            numHealth = new PropertyReaderImpl(this._lbConfig, "number-healthcheck-retries", "3");
            ++propSize;
        }
        if (this._lbConfig.getElementPropertyByName("rewrite-location") == null) {
            rewriteLoc = new PropertyReaderImpl(this._lbConfig, "rewrite-location", "true");
            ++propSize;
        }
        int i = 0;
        PropertyReader[] props = new PropertyReaderImpl[propSize + 4];
        props[i++] = new PropertyReaderImpl(this._lbConfig, "response-timeout-in-seconds");
        props[i++] = new PropertyReaderImpl(this._lbConfig, "reload-poll-interval-in-seconds");
        props[i++] = new PropertyReaderImpl(this._lbConfig, "https-routing");
        props[i++] = new PropertyReaderImpl(this._lbConfig, "require-monitor-data");
        for (ElementProperty prop : properties) {
            props[i++] = new PropertyReaderImpl(this._lbConfig, prop.getName());
        }
        if (activeHealth != null) {
            props[i++] = activeHealth;
        }
        if (numHealth != null) {
            props[i++] = numHealth;
        }
        if (rewriteLoc != null) {
            props[i++] = rewriteLoc;
        }
        return props;
    }

    public ClusterReader[] getClusters() throws LbReaderException {
        ArrayList<ClusterReaderImpl> list = new ArrayList<ClusterReaderImpl>();
        ClusterRef[] clusters = this._lbConfig.getClusterRef();
        ServerRef[] servers = this._lbConfig.getServerRef();
        if (!(clusters != null && clusters.length != 0 || servers != null && servers.length != 0)) {
            return null;
        }
        int total = clusters.length + servers.length;
        ClusterReader clImpls = null;
        for (int i = 0; i < clusters.length; ++i) {
            clImpls = new ClusterReaderImpl(this._ctx, this._lbConfig.getClusterRef(i));
            list.add((ClusterReaderImpl)clImpls);
        }
        for (int j = clusters.length; j < total; ++j) {
            clImpls = new StandAloneClusterReaderImpl(this._ctx, this._lbConfig.getServerRef(j - clusters.length));
            list.add((ClusterReaderImpl)clImpls);
        }
        ClusterReader[] cls = new ClusterReader[list.size()];
        return list.toArray(cls);
    }

    public String getName() throws LbReaderException {
        return this._lbConfig.getName();
    }

    public void accept(Visitor v) {
        LoadbalancerVisitor cv = (LoadbalancerVisitor)v;
        cv.visit(this);
    }
}

