/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.ClusterEvent;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.ee.admin.mbeans.EEConfigMBeanObjectNames;
import com.sun.enterprise.ee.admin.mbeans.GMSClient;
import com.sun.enterprise.ee.admin.mbeans.GMSClientMBeanHelper;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import com.sun.enterprise.server.ApplicationServer;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMSClientMBean
extends NotificationBroadcasterSupport
implements GMSClient {
    private Logger _logger;
    private final Map<String, GroupManagementService> gmsInstances = new Hashtable<String, GroupManagementService>();
    private final GMSClientMBeanHelper gmsHelper = new GMSClientMBeanHelper(this);
    private static final String[] types = new String[]{"cluster.health.INSTANCE_STARTED_EVENT", "cluster.health.INSTANCE_STOPPED_EVENT", "cluster.health.INSTANCE_FAILED_EVENT"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "com.sun.enterprise.ee.admin.mbeans.GMSNotification", "Notifications sent by the GMS Client MBean")};

    public GMSClientMBean() {
        AdminEventListenerRegistry.addEventListener((String)ClusterEvent.eventType, (AdminEventListener)this.gmsHelper);
    }

    private Logger getLogger() {
        if (this._logger == null) {
            this._logger = GMSLogDomain.getLogger((String)"ShoalLogger");
        }
        return this._logger;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    @Override
    public Map<String, List<Long>> getClusterHealth(String clusterName) {
        return this.gmsHelper.getClusterHealth(clusterName);
    }

    @Override
    public void initGMSGroupForAllClusters() {
        ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
        try {
            Cluster[] clusters;
            for (Cluster cluster : clusters = ClusterHelper.getClustersInDomain((ConfigContext)configContext)) {
                this.initGMSGroupForNamedCluster(cluster.getName());
            }
        }
        catch (ConfigException e) {
            this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    @Override
    public void initGMSGroupForNamedCluster(String clusterName) {
        this.gmsHelper.initGMSGroupForNamedCluster(clusterName);
    }

    @Override
    public void leaveGMSGroupForAllClusters(GMSConstants.shutdownType shutdownType2) {
        ConfigContext configContext = ApplicationServer.getServerContext().getConfigContext();
        try {
            Cluster[] clusters;
            for (Cluster cluster : clusters = ClusterHelper.getClustersInDomain((ConfigContext)configContext)) {
                this.leaveGMSGroupForNamedCluster(cluster.getName(), shutdownType2);
            }
        }
        catch (ConfigException e) {
            this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    @Override
    public void leaveGMSGroupForNamedCluster(String clusterName, GMSConstants.shutdownType shutdownType2) {
        this.gmsHelper.leaveGMSGroupForNamedCluster(clusterName, shutdownType2);
    }

    void sendFailureNotification(String memberToken, long time, int seqNum) {
        Notification notif = new Notification(types[2], (Object)this.getGMSMBeanObjectName(), (long)seqNum, time);
        notif.setUserData(memberToken);
        this.sendNotification(notif);
    }

    void sendStartNotification(String memberToken, long startTime, int seqNum) {
        Notification notif = new Notification(types[0], (Object)this.getGMSMBeanObjectName(), (long)seqNum, startTime);
        notif.setUserData(memberToken);
        this.sendNotification(notif);
    }

    void sendStoppedNotification(String memberToken, long time, int seqNum) {
        Notification notif = new Notification(types[1], (Object)this.getGMSMBeanObjectName(), (long)seqNum, time);
        notif.setUserData(memberToken);
        this.sendNotification(notif);
    }

    private ObjectName getGMSMBeanObjectName() {
        ObjectName gmsObjName = null;
        try {
            gmsObjName = EEConfigMBeanObjectNames.getGMSClientObjName();
        }
        catch (MalformedObjectNameException e) {
            this.getLogger().log(Level.WARNING, e.getLocalizedMessage());
        }
        return gmsObjName;
    }
}

