/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.servermgmt.pe.PEInstancesManager;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.ee.admin.servermgmt.EEFileLayout;
import com.sun.enterprise.ee.admin.servermgmt.EEScriptsTokens;
import com.sun.enterprise.ee.admin.servermgmt.InstanceConfig;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;

public class EEInstancesManager
extends PEInstancesManager {
    private static final StringManager _strMgr = StringManager.getManager(EEInstancesManager.class);
    private Properties _overridingProperties = null;

    public EEInstancesManager(RepositoryConfig config) {
        super(config);
        this._fileLayout = new EEFileLayout(config);
        this.setMessages(new RepositoryManager.RepositoryManagerMessages((RepositoryManager)this, _strMgr, "illegalInstanceName", "instanceName", "instanceRoot", "instanceExists", "instanceDoesntExist", "instanceDirNotValid", "cannotDeleteInstanceDir", "invalidInstanceDir", "listInstanceElement", "cannotDeleteInstance_invalidState", "instanceStartupException", "cannotStartInstance_invalidState", "startInstanceTimeOut", "portConflict", "instanceStartupFailed", "cannotStopInstance_invalidState", "cannotStopInstance", "instanceTimeoutStarting"));
    }

    public EEInstancesManager(RepositoryConfig config, RepositoryManager.RepositoryManagerMessages messages) {
        this(config);
        this.setMessages(messages);
    }

    public String getNativeName() {
        return "appserv";
    }

    protected InstanceConfig getInstanceConfig() {
        return (InstanceConfig)this.getConfig();
    }

    protected ProcessExecutor startInstanceExecute(String[] command, String[] interativeOptions) throws InstanceException {
        try {
            ProcessExecutor exec = new ProcessExecutor(command, interativeOptions);
            exec.execute(false, false);
            return exec;
        }
        catch (Exception e) {
            throw new InstanceException(_strMgr.getString("procExecError"), (Throwable)e);
        }
    }

    public void createInstance() throws InstanceException {
        try {
            this.checkRepository(this.getInstanceConfig(), false);
        }
        catch (RepositoryException ex) {
            throw new InstanceException((Throwable)ex);
        }
        try {
            this.getEEFileLayout().createServerInstanceDirectories();
            this.createStartInstance();
            this.createStopInstance();
            this.setPermissions(this.getConfig());
        }
        catch (InstanceException ex) {
            FileUtils.liquidate((File)this.getInstanceDir());
            throw ex;
        }
        catch (Exception ex) {
            FileUtils.liquidate((File)this.getInstanceDir());
            throw new InstanceException((Throwable)ex);
        }
    }

    private String getJbiInstanceName() {
        InstanceConfig config = this.getInstanceConfig();
        if (config.getInstanceName() == null) {
            return config.getRepositoryName();
        }
        return config.getInstanceName();
    }

    public void deleteInstance() throws InstanceException {
        this.deleteInstance(true);
    }

    public void deleteInstance(boolean deleteJMSProvider) throws InstanceException {
        try {
            this.deleteRepository(this.getInstanceConfig(), deleteJMSProvider);
        }
        catch (Exception e) {
            throw new InstanceException((Throwable)e);
        }
    }

    public String[] listInstances() throws InstanceException {
        try {
            return this.listRepository(this.getConfig());
        }
        catch (Exception e) {
            throw new InstanceException((Throwable)e);
        }
    }

    protected RepositoryConfig getConfigForRepositoryStatus(RepositoryConfig config, String repository) {
        return new RepositoryConfig(config.getRepositoryName(), config.getRepositoryRoot(), repository);
    }

    public String[] listInstancesAndStatusAsString() throws InstanceException {
        try {
            return this.listDomainsAndStatusAsString(this.getConfig());
        }
        catch (Exception e) {
            throw new InstanceException((Throwable)e);
        }
    }

    public Process startInstance() throws InstanceException {
        try {
            this.checkRepository(this.getConfig());
            String[] commandLineArgs = null;
            return super.startInstance(IdentityManager.getIdentityArray(), commandLineArgs, this.getEnvProps());
        }
        catch (Exception e) {
            throw new InstanceException((Throwable)e);
        }
    }

    public void stopInstance() throws InstanceException {
        try {
            this.checkRepository(this.getConfig());
            super.stopInstance();
        }
        catch (Exception e) {
            throw new InstanceException((Throwable)e);
        }
    }

    protected EEFileLayout getEEFileLayout() {
        return (EEFileLayout)this._fileLayout;
    }

    protected PEFileLayout getFileLayout() {
        return this._fileLayout;
    }

    protected PEFileLayout getFileLayout(RepositoryConfig config) {
        return this._fileLayout;
    }

    private void createStartInstance() throws InstanceException {
        try {
            TokenValueSet tokens = EEScriptsTokens.getTokenValueSet(this.getInstanceConfig());
            Properties props = this.getOverridingProperties();
            if (props != null) {
                Iterator<Object> iter = props.keySet().iterator();
                String key = "";
                TokenValue tv = null;
                while (iter.hasNext()) {
                    key = (String)iter.next();
                    tv = new TokenValue(key, props.getProperty(key));
                    tokens.add(tv);
                }
            }
            this.generateFromTemplate(tokens, this.getEEFileLayout().getStartInstanceTemplate(), this.getEEFileLayout().getStartInstance());
        }
        catch (Exception e) {
            throw new InstanceException(_strMgr.getString("startInstanceNotCreated"), (Throwable)e);
        }
    }

    private void createStopInstance() throws InstanceException {
        try {
            TokenValueSet tokens = EEScriptsTokens.getTokenValueSet(this.getInstanceConfig());
            this.generateFromTemplate(tokens, this.getEEFileLayout().getStopInstanceTemplate(), this.getEEFileLayout().getStopInstance());
        }
        catch (Exception e) {
            throw new InstanceException(_strMgr.getString("stopInstanceNotCreated"), (Throwable)e);
        }
    }

    protected boolean isValidRepository(File f) {
        if (f.getName().equals("agent")) {
            return false;
        }
        return super.isValidRepository(f);
    }

    protected boolean isValidRepository(RepositoryConfig config) {
        String instanceName = config.getInstanceName();
        if (instanceName != null && instanceName.equals("agent")) {
            return false;
        }
        return super.isValidRepository(config);
    }

    public InstancesManager getInstancesManager(RepositoryConfig config) {
        return new EEInstancesManager(config);
    }

    public void setOverridingProperties(Properties props) {
        this._overridingProperties = props;
    }

    public Properties getOverridingProperties() {
        return this._overridingProperties;
    }

    private File getInstanceDir() {
        return this.getFileLayout().getRepositoryDir();
    }

    protected File getRepositoryDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryDir();
    }

    protected File getRepositoryRootDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryDir().getParentFile();
    }

    protected Properties getEnvProps() {
        RepositoryConfig cfg = this.getConfig();
        Properties p = new Properties();
        p.setProperty("com.sun.aas.instanceRoot", cfg.getRepositoryRoot() + File.separator + cfg.getRepositoryName() + File.separator + cfg.getInstanceName());
        p.setProperty("com.sun.aas.launcherReturn", "return");
        p.setProperty("com.sun.aas.instanceName", cfg.getInstanceName());
        p.setProperty("com.sun.aas.processName", "as9-server");
        p.setProperty("com.sun.aas.processLauncher", "SE");
        p.setProperty("com.sun.aas.limitedCommamdExecution", "true");
        return p;
    }
}

