/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.admin.servermgmt.InstancesManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.ee.admin.servermgmt.EEDomainsManager;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;

public abstract class BaseNodeAgentCommand
extends BaseLifeCycleCommand {
    private static final StringManager _strMgr = StringManager.getManager(BaseNodeAgentCommand.class);
    protected static final String AGENTDIR = "agentdir";
    private static final String NODE_AGENT_DIRECTORY_NAME = "nodeagents";
    protected static final String START_INSTANCES_OVERRIDE = "startinstances";
    protected static final String SYNC_INSTANCES_OVERRIDE = "syncinstances";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    protected String getAgentPath() throws CommandException {
        File f;
        String path = this.getOption(AGENTDIR);
        if (path == null && (f = new File(path = System.getProperty("com.sun.aas.domainsRoot")).getParentFile()) != null) {
            try {
                path = new File(f, NODE_AGENT_DIRECTORY_NAME).getCanonicalPath();
            }
            catch (Exception ex) {
                throw new CommandException(_strMgr.getString("InvalidNodeAgentPath"), (Throwable)ex);
            }
        }
        if (path == null) {
            throw new CommandException(_strMgr.getString("InvalidNodeAgentPath"));
        }
        return path;
    }

    protected String[] getAgents() throws CommandException {
        try {
            AgentConfig agentConfig = new AgentConfig(null, this.getAgentPath());
            AgentManager manager = this.getAgentManager(agentConfig);
            return manager.listNodeAgents();
        }
        catch (Exception ex) {
            throw new CommandException((Throwable)ex);
        }
    }

    protected String getAgentName() throws CommandException {
        String agentName = null;
        if (this.operands.isEmpty()) {
            String[] agents = this.getAgents();
            if (agents.length == 0) {
                throw new CommandException(_strMgr.getString("NoAgents", new Object[]{this.getAgentPath()}));
            }
            if (agents.length > 1) {
                throw new CommandException(_strMgr.getString("NoDefaultAgent", new Object[]{this.getAgentPath()}));
            }
            agentName = agents[0];
        } else {
            agentName = (String)this.operands.firstElement();
        }
        CLILogger.getInstance().printDebugMessage("agentName =" + agentName);
        return agentName;
    }

    protected int convertPortStr(String port) throws CommandValidationException {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new CommandValidationException((Throwable)e);
        }
    }

    protected AgentManager getAgentManager(AgentConfig agentConfig) {
        EEDomainsManager domainsManager = (EEDomainsManager)this.getFeatureFactory().getDomainsManager();
        return domainsManager.getAgentManager(agentConfig);
    }

    boolean isNotRunning(AgentManager mgr, AgentConfig cfg) throws Exception {
        InstancesManager im = mgr.getInstancesManager(cfg);
        int state = im.getInstanceStatus();
        return state == 3;
    }

    String getMasterPasswordWithDefaultPrompt(RepositoryManager mgr, RepositoryConfig config) throws CommandValidationException, CommandException {
        String mpassword = this.getPassword("masterpassword", "MasterPasswordWithDefaultPrompt", "", false, false, false, true, mgr, config, true, false, false, false);
        if (mpassword != null && mpassword.length() > 0) {
            return mpassword;
        }
        return "changeit";
    }
}

