/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.deployment;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.mbeans.ApplicationsConfigMBean;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.deployment.phasing.DeploymentService;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class EEApplicationsConfigMBean
extends ApplicationsConfigMBean {
    public EEApplicationsConfigMBean(String instanceName, ConfigContext ctx) throws MBeanConfigException {
        super(instanceName, ctx);
        this.mInstanceName = instanceName;
        this.m_configContext = ctx;
        this.deployService = DeploymentService.getDeploymentService((ConfigContext)ctx);
    }

    public EEApplicationsConfigMBean() throws MBeanConfigException {
    }

    public String[] getTargets() throws MBeanConfigException {
        try {
            int i;
            ArrayList<Object> targetList = new ArrayList<Object>();
            MBeanServer mbs = MBeanServerFactory.getMBeanServer();
            AdminContext ac = MBeanRegistryFactory.getAdminContext();
            MBeanRegistry mr = MBeanRegistryFactory.getAdminMBeanRegistry();
            String dn = ac.getDomainName();
            String servers = "servers";
            String server = "server";
            String cluster = "clusters";
            String[] locations = new String[]{dn};
            ObjectName serversON = mr.getMbeanObjectName("servers", locations);
            ObjectName groupsON = mr.getMbeanObjectName("clusters", locations);
            try {
                ObjectName[] groupONArr = (ObjectName[])mbs.invoke(groupsON, "getCluster", emptyParams, emptySignature);
                for (i = 0; i < groupONArr.length; ++i) {
                    targetList.add(mbs.getAttribute(groupONArr[i], "name"));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                ObjectName[] serverONArr = (ObjectName[])mbs.invoke(serversON, "getServer", emptyParams, emptySignature);
                for (i = 0; i < serverONArr.length; ++i) {
                    String serverName = (String)mbs.getAttribute(serverONArr[i], "name");
                    String[] locs = new String[]{dn, serverName};
                    ObjectName mbeanName = mr.getMbeanObjectName("server", locs);
                    Boolean clustered = (Boolean)mbs.invoke(mbeanName, "isClustered", emptyParams, emptySignature);
                    if (clustered.booleanValue()) continue;
                    targetList.add(serverName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                targetList.add("server");
            }
            return targetList.toArray(new String[0]);
        }
        catch (Throwable t) {
            throw new MBeanConfigException(t.getMessage());
        }
    }
}

