/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.diagnostics;

import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ExecutionContext;
import com.sun.enterprise.diagnostics.ReportConfig;
import com.sun.enterprise.diagnostics.ReportGenerator;
import com.sun.enterprise.diagnostics.ServiceConfig;
import com.sun.enterprise.diagnostics.SingleInstanceObjectFactory;
import com.sun.enterprise.diagnostics.TargetResolver;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.report.html.HTMLReportWriter;
import com.sun.enterprise.ee.diagnostics.EEExecutionContext;
import com.sun.enterprise.ee.diagnostics.EELocalTargetResolver;
import com.sun.enterprise.ee.diagnostics.EERemoteTargetResolver;
import com.sun.enterprise.ee.diagnostics.EEReportGenerator;
import com.sun.enterprise.ee.diagnostics.EETargetType;
import com.sun.enterprise.ee.diagnostics.collect.DomainHarvester;
import com.sun.enterprise.ee.diagnostics.collect.NodeAgentHarvester;
import com.sun.enterprise.ee.diagnostics.report.html.EEHTMLReportWriter;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEBackendObjectFactory
extends SingleInstanceObjectFactory {
    private List<String> instances;
    private String targetType;
    private Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.admin");

    public EEBackendObjectFactory(Map input, List<String> instances, String targetType) {
        super(input);
        this.instances = instances;
        this.targetType = targetType;
    }

    public TargetResolver createTargetResolver(boolean local) throws DiagnosticException {
        EETargetType type = null;
        if (this.targetType != null) {
            type = new EETargetType(this.targetType);
        }
        if (local) {
            this.logger.log(Level.FINEST, "diagnostic-service.local_target_resolver");
            return new EELocalTargetResolver(this.options.getTargetName(), this.options.getTargetDir(), this.instances, type);
        }
        this.logger.log(Level.FINEST, "diagnostic-service.remote_target_resolver");
        return new EERemoteTargetResolver(this.options.getTargetName(), this.options.getTargetDir(), this.instances, type);
    }

    public Collector createHarvester() {
        ExecutionContext context = this.config.getExecutionContext();
        if (context.equals((Object)EEExecutionContext.DAS_EC)) {
            this.logger.log(Level.FINEST, "diagnostic-service.domain_harvester");
            return new DomainHarvester(this.getReportConfig());
        }
        this.logger.log(Level.FINEST, "diagnostic-service.nodeagent_resolver");
        return new NodeAgentHarvester(this.getReportConfig());
    }

    public HTMLReportWriter createHTMLReportWriter() {
        return new EEHTMLReportWriter(this.config);
    }

    public ReportGenerator createReportGenerator(ReportConfig config, Collector harvester, HTMLReportWriter reportWriter) throws DiagnosticException {
        return new EEReportGenerator(config, harvester, reportWriter);
    }

    protected void analyzeInput() throws DiagnosticException {
        Map configs;
        super.analyzeInput();
        if (this.config != null && this.context.equals((Object)EEExecutionContext.NODEAGENT_EC) && (configs = (Map)this.options.getMap().get("configs")) != null) {
            String agentRepDir = this.target.getRepositoryDir() + File.separator + this.target.getRepositoryName();
            String instanceRepDir = null;
            for (String instance : this.instances) {
                Map instanceConfig = (Map)configs.get(instance);
                if (!instance.equals("server") && !this.target.getType().equals((Object)TargetType.INSTANCE)) {
                    instanceRepDir = agentRepDir + File.separator + instance;
                }
                this.config.addInstanceSpecificConfig(new ServiceConfig(((Boolean)instanceConfig.get("compute-checksum")).booleanValue(), ((Boolean)instanceConfig.get("capture-app-dd")).booleanValue(), ((Boolean)instanceConfig.get("capture-install-log")).booleanValue(), ((Boolean)instanceConfig.get("verify-config")).booleanValue(), ((Boolean)instanceConfig.get("capture-hadb-info")).booleanValue(), ((Boolean)instanceConfig.get("capture-system-info")).booleanValue(), ((Integer)instanceConfig.get("min-log-level")).intValue(), ((Integer)instanceConfig.get("max-log-entries")).intValue(), (String)instanceConfig.get("log-file"), instanceRepDir, instance));
            }
        }
    }
}

