/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.diagnostics;

import com.sun.enterprise.diagnostics.BackendObjectFactory;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.PEDiagnosticAgent;
import com.sun.enterprise.diagnostics.collect.DomainXMLHelper;
import com.sun.enterprise.ee.diagnostics.EEBackendObjectFactory;
import com.sun.enterprise.ee.diagnostics.EEConstants;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEDiagnosticAgent
extends PEDiagnosticAgent {
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.admin");
    private static final String INSTANCES = "instances";
    private static final String TARGET_TYPE = "targettype";

    public String generateReport(Map clioptions, List<String> instances, String targetType) throws DiagnosticException {
        logger.log(Level.FINEST, "Inside EE Diagnostic Agent for node agent");
        clioptions.put(INSTANCES, instances);
        clioptions.put(TARGET_TYPE, targetType);
        logger.log(Level.FINEST, "diagnostic-service.instances", instances);
        logger.log(Level.FINEST, "diagnostic-service.target_type", targetType);
        return this.generateReport(clioptions);
    }

    public List<String> getConfidentialProperties(String repositoryDir) throws DiagnosticException {
        String agentRepository = repositoryDir + EEConstants.AGENT_DIR;
        File agentDir = new File(agentRepository);
        if (agentDir.exists()) {
            repositoryDir = agentRepository;
        }
        return new DomainXMLHelper(repositoryDir).getAttrs();
    }

    public void deleteReport(String fileName) throws DiagnosticException {
        File file;
        if (fileName != null && (file = new File(fileName)).exists()) {
            file.delete();
        }
    }

    protected BackendObjectFactory getBackendObjectFactory(Map input) {
        List instances = (List)input.get(INSTANCES);
        return new EEBackendObjectFactory(input, instances, (String)input.get(TARGET_TYPE));
    }
}

