/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.diagnostics.collect;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ReportConfig;
import com.sun.enterprise.diagnostics.ServiceConfigHelper;
import com.sun.enterprise.diagnostics.TargetType;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.Harvester;
import com.sun.enterprise.diagnostics.collect.MonitoringInfoCollector;
import com.sun.enterprise.ee.diagnostics.EETargetType;
import com.sun.enterprise.ee.diagnostics.collect.HadbInfoCollector;
import com.sun.enterprise.ee.diagnostics.collect.NodeAgentDataCollector;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainHarvester
extends Harvester {
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.admin");
    private Map nodeAgentToInstances = new HashMap(5);

    public DomainHarvester(ReportConfig config) {
        super(config);
        this.populateNodeAgentToInstances();
    }

    public void addRemoteCollectors() throws DiagnosticException {
        this.addDomainCollectors();
    }

    private void populateNodeAgentToInstances() {
        List instances = this.config.getTarget().getInstances();
        if (instances != null) {
            Iterator iterator = instances.iterator();
            ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            while (iterator.hasNext()) {
                try {
                    String instanceName = (String)iterator.next();
                    if (instanceName.equals("server")) continue;
                    Server server = ServerHelper.getServerByName((ConfigContext)configContext, (String)instanceName);
                    String nodeAgent = server.getNodeAgentRef();
                    Object obj = this.nodeAgentToInstances.get(nodeAgent);
                    if (obj == null) {
                        obj = new ArrayList(5);
                    }
                    ArrayList list = (ArrayList)obj;
                    list.add(instanceName);
                    this.nodeAgentToInstances.put(nodeAgent, list);
                }
                catch (ConfigException ce) {
                    logger.log(Level.WARNING, "diagnostic-service.error_retrieving_na", ce);
                }
            }
        }
    }

    private void addDomainCollectors() throws DiagnosticException {
        boolean captureHadbInfoEnabled;
        Clusters clusters;
        Domain domain;
        ConfigContext configContext;
        Set keys = this.nodeAgentToInstances.keySet();
        for (String nodeAgent : keys) {
            if (nodeAgent == null) continue;
            List naInstances = (List)this.nodeAgentToInstances.get(nodeAgent);
            this.addCollector(new NodeAgentDataCollector(this.config.getCLIOptions(), nodeAgent, naInstances, this.config.getTarget().getType().getType()));
            if (this.target.getType().equals((Object)EETargetType.NODEAGENT) || this.target.getType().equals((Object)EETargetType.INSTANCE)) {
                nodeAgent = null;
            }
            this.addMonitoringInfoCollectors(nodeAgent, naInstances);
        }
        if (keys.size() == 0 && this.target.getType().equals((Object)EETargetType.NODEAGENT)) {
            this.addCollector(new NodeAgentDataCollector(this.config.getCLIOptions(), this.target.getName(), new ArrayList<String>(), this.config.getTarget().getType().getType()));
        }
        String reportDir = this.config.getTarget().getIntermediateReportDir();
        if (this.target.getType().equals((Object)TargetType.DAS) || this.target.getType().equals((Object)EETargetType.DOMAIN)) {
            this.addCollector((Collector)new MonitoringInfoCollector(null, "server", this.target.getIntermediateReportDir()));
        }
        if (this.target.getType().equals((Object)EETargetType.CLUSTER)) {
            if (keys.size() == 0) {
                throw new DiagnosticException("Cannot collect diagnostic information for cluster [ " + this.target.getName() + " ] without any instance");
            }
            try {
                configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
                domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext);
                clusters = domain.getClusters();
                Cluster targetCluster = clusters.getClusterByName(this.target.getName());
                captureHadbInfoEnabled = this.isHadbCaptureEnabled(configContext, targetCluster.getName());
                this.addHadbInfoCollector(captureHadbInfoEnabled, this.target.getName(), reportDir);
            }
            catch (ConfigException ce) {
                logger.log(Level.WARNING, "Config Exception", ce);
            }
            catch (DiagnosticException de) {
                logger.log(Level.WARNING, "Diagnostic Exception", de);
            }
        }
        if (this.target.getType().equals((Object)EETargetType.DOMAIN)) {
            try {
                configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
                domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext);
                clusters = domain.getClusters();
                Cluster[] clusterArray = clusters.getCluster();
                captureHadbInfoEnabled = false;
                for (Cluster cluster : clusterArray) {
                    captureHadbInfoEnabled = this.isHadbCaptureEnabled(configContext, cluster.getName());
                    this.addHadbInfoCollector(captureHadbInfoEnabled, cluster.getName(), reportDir);
                }
            }
            catch (ConfigException ce) {
                logger.log(Level.WARNING, "Config Exception", ce);
            }
            catch (DiagnosticException de) {
                logger.log(Level.WARNING, "Diagnostic Exception", de);
            }
        }
    }

    private boolean isHadbCaptureEnabled(ConfigContext configContext, String clusterName) throws ConfigException, DiagnosticException {
        boolean captureHadbInfoEnabled = false;
        Server[] instances = ServerHelper.getServersInCluster((ConfigContext)configContext, (String)clusterName);
        if (instances != null && instances.length > 0) {
            ServiceConfigHelper configHelper = new ServiceConfigHelper(this.target.getRepositoryDir() + File.separator + this.target.getRepositoryName(), instances[0].getName(), true);
            String booleanValue = configHelper.getAttribute("capture-hadb-info");
            captureHadbInfoEnabled = Boolean.parseBoolean(booleanValue);
        }
        return captureHadbInfoEnabled;
    }

    private void addHadbInfoCollector(boolean captureHadbInfoCollectorEnabled, String targetName, String reportDir) {
        if (captureHadbInfoCollectorEnabled) {
            this.addCollector(new HadbInfoCollector(targetName, reportDir));
        }
    }
}

