/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.diagnostics.collect;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.server.core.jmx.AppServerMBeanServerFactory;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class HadbInfoCollector
implements Collector {
    private static final String GET_COMMAND = " get ";
    private static final String LIST_COMMAND = " list ";
    private static Logger logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.admin");
    private static final String HADBM = "hadbm ";
    private static int ERROR = -1;
    private static int NOERROR = 0;
    private static boolean isOldHadbVer = false;
    private String adminPassword;
    private String databaseName;
    private String clusterName;
    private String destFolder;
    private static final String OBJECT_NAME = "com.sun.appserv:type=hadb-config,category=config";
    public static final String STRING = new String().getClass().getName();

    public HadbInfoCollector(String clusterName, String destFolder) {
        try {
            this.clusterName = clusterName;
            this.initialize(clusterName);
            this.destFolder = destFolder;
        }
        catch (ConfigException ce) {
            logger.log(Level.WARNING, ce.getMessage(), ce.fillInStackTrace());
        }
    }

    private void initialize(String clusterName) throws ConfigException {
        Domain domain;
        Clusters clusters;
        Cluster cluster;
        String configReference;
        ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        Config config = ConfigAPIHelper.getConfigByName((ConfigContext)configContext, (String)(configReference = (cluster = (clusters = (domain = ServerBeansFactory.getDomainBean((ConfigContext)configContext)).getClusters()).getClusterByName(clusterName)).getConfigRef()));
        AvailabilityService availService = config.getAvailabilityService();
        if (availService.isAvailabilityEnabled()) {
            ConfigBean conPoolResource;
            JdbcResource jdbcResource;
            String poolName;
            ConfigBean resource;
            String storePoolName = availService.getStorePoolName();
            this.databaseName = availService.getHaStoreName();
            if ("JdbcResource".equals(ResourceHelper.getResourceType((ConfigContext)configContext, (String)storePoolName)) && (resource = ResourceHelper.findResource((ConfigContext)configContext, (String)storePoolName)) instanceof JdbcResource && "JdbcConnectionPool".equals(ResourceHelper.getResourceType((ConfigContext)configContext, (String)(poolName = (jdbcResource = (JdbcResource)resource).getPoolName()))) && (conPoolResource = ResourceHelper.findResource((ConfigContext)configContext, (String)poolName)) instanceof JdbcConnectionPool) {
                ElementProperty passwordProperty = ((JdbcConnectionPool)conPoolResource).getElementPropertyByName("Password");
                this.adminPassword = passwordProperty.getValue();
            }
        }
    }

    public Data capture() throws DiagnosticException {
        FileData data = null;
        if (this.adminPassword == null) {
            logger.log(Level.WARNING, "Admin Password in HADBInfoCollector is null");
            return data;
        }
        if (this.databaseName == null) {
            logger.log(Level.WARNING, "Database Name in HADBInfoCollector is null");
            return data;
        }
        Object[] params = new Object[]{null, null, this.adminPassword, null, this.databaseName};
        String[] types = new String[]{STRING, STRING, STRING, STRING, STRING};
        MBeanServer mbs = AppServerMBeanServerFactory.getMBeanServerInstance();
        try {
            Object[] returnValues = (Object[])mbs.invoke(new ObjectName(OBJECT_NAME), "getHADBInfo", params, types);
            File parent = new File(this.destFolder);
            parent.mkdirs();
            String fileName = this.destFolder + Defaults.HADB_INFO_FILE + "_" + this.clusterName;
            File file = new File(fileName);
            PrintWriter writer = new PrintWriter(fileName);
            for (Object value : returnValues) {
                writer.write(value.toString() + "\n");
            }
            writer.close();
            data = new FileData(file.getName(), "hadb info");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e.fillInStackTrace());
        }
        return data;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }
}

