/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.nodeagent;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.ee.admin.servermgmt.AgentException;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.NodeAgentPropertyReader;
import com.sun.enterprise.ee.nodeagent.NodeAgent;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class BaseNodeAgent {
    protected static final String MBEAN_SERVER_DOMAIN = "com.sun.appserver.nodeagent";
    protected static final int DEFAULT_CONNECTOR_PORT = 9900;
    protected int _port = 9900;
    protected static final String JMX_SERVER_MBEAN_PREFIX = ":name=JmxConnectorServer,port=";
    protected static final String JMX_SERVER_MBEAN_SEARCH = ":name=JmxConnectorServer,*";
    protected static final String RELATIVE_LOCATION_DOMAIN_XML = "/config/domain.xml";
    protected static final String[] LOCAL_DAS_SYNC_FILES = new String[]{"/config/domain.xml", "/config/.domain.xml.timestamp", "/config/domain.xml_save"};
    protected static final String INSTANCE_SYNC_JVM_OPTIONS = "INSTANCE-SYNC-JVM-OPTIONS";
    protected Logger _logger = null;
    protected MBeanServer _server = null;
    protected DASPropertyReader _dasReader = null;
    protected NodeAgentPropertyReader _naReader = null;
    private static ConfigContext _configCtxt = null;
    protected static boolean _isNodeAgent = false;
    protected static final StringManager _strMgr = StringManager.getManager(NodeAgent.class);
    protected boolean bDebug = Boolean.getBoolean("Debug");

    protected abstract void rendezvousWithDAS() throws Exception;

    protected abstract Vector synchronizeWithDASInternal() throws AgentException;

    protected abstract void configureLogger() throws Exception;

    protected abstract void configureAgent() throws Exception;

    protected abstract void postStartupProcessing(String var1, boolean var2) throws Exception;

    protected abstract void shutdownProcessing() throws Exception;

    public void run(String startInstancesOverride, boolean syncInstancesOverride) throws Exception {
        if (System.getProperty("Debug") != null) {
            this.bDebug = true;
        }
        this.configureLogger();
        if (this.getNodeAgentPropertyReader().isDeleted()) {
            this.getLogger().log(Level.WARNING, "nodeagent.isDeleted");
            this.stopAgentWithPause();
        }
        if (this.getDASPropertyReader().getHost() != null && !this.getNodeAgentPropertyReader().isBound()) {
            try {
                this.rendezvousWithDAS();
            }
            catch (Exception e) {
                this.stopAgentWithPause();
            }
        }
        Vector createdInstances = null;
        if (this.getNodeAgentPropertyReader().isBound()) {
            createdInstances = this.synchronizeWithDASInternal();
        } else {
            this.stopAgentWithPause();
        }
        this.postStartupProcessing(startInstancesOverride, syncInstancesOverride);
    }

    protected void init() throws AgentException {
        this.getLogger().log(Level.FINE, "Initializing NodeAgent...");
        try {
            this.configureAgent();
        }
        catch (AgentException ae) {
            throw ae;
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "nodeagent.initialization.Exception", e);
            throw new AgentException(e);
        }
    }

    protected void registerLogger(Level level, String file) throws IOException {
        if (this.bDebug) {
            this.getLogger().setLevel(Level.FINEST);
        } else {
            this.getLogger().setLevel(level);
        }
    }

    protected boolean isPortRegistered(Vector vtCurrent, String port) throws Exception {
        ObjectName nameSearch;
        boolean bRet = false;
        if (this.bDebug) {
            System.out.println("Looking for :" + this._server.getDefaultDomain() + JMX_SERVER_MBEAN_PREFIX + port);
            for (int ii = 0; ii < vtCurrent.size(); ++ii) {
                System.out.println("\t" + (ObjectName)vtCurrent.get(ii));
            }
        }
        if (vtCurrent.contains(nameSearch = new ObjectName(this._server.getDefaultDomain() + JMX_SERVER_MBEAN_PREFIX + port))) {
            bRet = true;
        }
        vtCurrent.remove(nameSearch);
        return bRet;
    }

    protected void query() {
        try {
            ObjectName nameSearch = new ObjectName(this._server.getDefaultDomain() + ":*");
            Set<ObjectName> ls = this._server.queryNames(nameSearch, null);
            Iterator<ObjectName> it = ls.iterator();
            ObjectName objectName = null;
            Object currPort = null;
            while (it.hasNext()) {
                objectName = it.next();
                System.out.println("*** currently registered connectors: " + objectName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void registerMBean(Object mbean, String type) throws Exception {
        ObjectName objname = new ObjectName(this._server.getDefaultDomain() + type);
        this._server.registerMBean(mbean, objname);
        this.getLogger().log(Level.CONFIG, "registered object: " + objname);
    }

    protected void setNodeAgentBindStatus(String status) throws IOException {
        if (this.bDebug) {
            System.out.println("Senting Node Agent Status to " + status);
        }
        this.getLogger().log(Level.FINE, "Setting NodeAgent Status to:" + status);
        this.getNodeAgentPropertyReader().setBindStatus(status);
        this.getNodeAgentPropertyReader().write();
    }

    public Logger getLogger() {
        if (this._logger == null) {
            this._logger = Logger.getLogger("javax.ee.enterprise.system.nodeagent", "com.sun.logging.ee.enterprise.system.nodeagent.LogStrings");
            if (this.bDebug) {
                this._logger.setLevel(Level.FINEST);
            } else {
                this._logger.setLevel(Level.CONFIG);
            }
        }
        return this._logger;
    }

    protected void setDASPropertyReader(DASPropertyReader dasReader) {
        this._dasReader = dasReader;
    }

    protected DASPropertyReader getDASPropertyReader() {
        return this._dasReader;
    }

    protected void setNodeAgentPropertyReader(NodeAgentPropertyReader naReader) {
        this._naReader = naReader;
    }

    protected NodeAgentPropertyReader getNodeAgentPropertyReader() {
        return this._naReader;
    }

    protected void setConfigContext(ConfigContext configContext) {
        _configCtxt = configContext;
    }

    protected static ConfigContext getConfigContext() {
        return _configCtxt;
    }

    protected void stopAgentWithPause() {
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getLogger().log(Level.WARNING, "nodeAgent.stopping.agent");
        System.exit(0);
    }
}

