/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.selfmanagement.actions;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.selfmanagement.actions.CheckListenerHealth;
import com.sun.enterprise.ee.selfmanagement.actions.Instance;
import com.sun.enterprise.ee.selfmanagement.actions.InstanceHangAction;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CheckServerHealth
implements Runnable {
    private static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.selfmanagement");
    private Instance instance = null;

    public CheckServerHealth(Instance value) {
        this.instance = value;
    }

    public void run() {
        Boolean isHealthy = false;
        try {
            HttpListener[] listeners;
            ArrayList<HttpListener> enabledListeners = new ArrayList<HttpListener>();
            Server serv = this.instance.getServer();
            ConfigContext cfgCtx = InstanceHangAction.configCtx;
            Config cfg = ServerHelper.getConfigForServer((ConfigContext)cfgCtx, (String)serv.getName());
            HttpService httpSrv = cfg.getHttpService();
            for (HttpListener listener : listeners = httpSrv.getHttpListener()) {
                if (!listener.isEnabled()) continue;
                enabledListeners.add(listener);
            }
            int size = enabledListeners.size();
            ExecutorService exSrv = Executors.newFixedThreadPool(size);
            ArrayList<Future<Boolean>> checkTasks = new ArrayList<Future<Boolean>>(size);
            int timeout = this.instance.getTimeout();
            boolean i = false;
            for (HttpListener httpListener : enabledListeners) {
                CheckListenerHealth checkListener = new CheckListenerHealth(serv, httpListener, timeout);
                Future<Boolean> task = exSrv.submit(checkListener);
                checkTasks.add(task);
            }
            for (Future future : checkTasks) {
                isHealthy = (Boolean)future.get();
                if (!isHealthy.booleanValue()) continue;
                if (this.instance.getClusterName() != null) {
                    _logger.log(Level.INFO, "sgmt.instancehang_clserverhealthy", new Object[]{serv.getName(), this.instance.getClusterName()});
                    break;
                }
                _logger.log(Level.INFO, "sgmt.instancehang_serverhealthy", serv.getName());
                break;
            }
            if (!isHealthy.booleanValue()) {
                String cName = this.instance.getClusterName();
                if (cName != null) {
                    _logger.log(Level.WARNING, "sgmt.instancehang_clserverunhealthy", new Object[]{cName, serv.getName()});
                } else {
                    _logger.log(Level.WARNING, "sgmt.instancehang_serverunhealthy", serv.getName());
                }
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            isHealthy = true;
        }
        catch (RejectedExecutionException ex) {
            isHealthy = true;
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        this.instance.setHealthy(isHealthy);
    }
}

