/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.audit;

import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.cleaner.CleanerUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class AuditReport {
    private SynchronizationResponse _response = null;
    private List _missingList = null;
    private List _extraList = null;
    private boolean _status = false;
    private static final int MAX_REPORT_CNT = 500;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManager _localStrMgr = StringManager.getManager(AuditReport.class);

    AuditReport(SynchronizationResponse res, List missing, List extra) {
        this._response = res;
        this._missingList = missing;
        this._extraList = extra;
    }

    boolean isAuditFailed() {
        return this._status;
    }

    void report() {
        StringBuffer buffer = new StringBuffer();
        String hdr = _localStrMgr.getString("reportHdr");
        buffer.append("\n" + hdr + "\n");
        String missingFiles = _localStrMgr.getString("missingFiles");
        buffer.append(missingFiles + "\n");
        int missingCnt = 0;
        boolean addMissingDots = false;
        int mSize = this._missingList.size();
        for (int i = 0; i < mSize; ++i) {
            String f = (String)this._missingList.get(i);
            if (CleanerUtils.isExcluded(f)) continue;
            if (missingCnt <= 500) {
                buffer.append(f + "\n");
            } else {
                addMissingDots = true;
            }
            ++missingCnt;
        }
        if (addMissingDots) {
            buffer.append("...\n");
        }
        String tMissingFiles = _localStrMgr.getString("totalMissingFiles");
        buffer.append("\t" + tMissingFiles + missingCnt + "\n");
        String extraFiles = _localStrMgr.getString("extraFiles");
        buffer.append(extraFiles + "\n");
        int extraCnt = 0;
        boolean addExtraDots = false;
        int eSize = this._extraList.size();
        for (int i = 0; i < eSize; ++i) {
            String f = (String)this._extraList.get(i);
            if (CleanerUtils.isExcluded(f)) continue;
            if (extraCnt <= 500) {
                buffer.append(f + "\n");
            } else {
                addExtraDots = true;
            }
            ++extraCnt;
        }
        if (addExtraDots) {
            buffer.append("...\n");
        }
        String tExtraFiles = _localStrMgr.getString("totalExtraFiles");
        buffer.append("\t" + tExtraFiles + extraCnt + "\n");
        List central = this._response.getFileList();
        if (missingCnt > 0 || extraCnt > 0 || _logger.isLoggable(Level.FINE)) {
            if (_logger.isLoggable(Level.FINE)) {
                String centralFiles = _localStrMgr.getString("centralFiles");
                buffer.append(centralFiles + "\n");
                int cSize = central.size();
                for (int i = 0; i < cSize; ++i) {
                    String cFile = (String)central.get(i);
                    if (i >= 500) continue;
                    buffer.append(cFile + "\n");
                }
                if (cSize > 500) {
                    buffer.append("...\n");
                }
                String tCentralFiles = _localStrMgr.getString("totalCentralFiles");
                buffer.append("\t" + tCentralFiles + cSize + "\n");
            }
            _logger.info(buffer.toString());
        } else {
            _logger.log(Level.INFO, "synchronization.audit_report_success", String.valueOf(central.size()));
        }
        if (missingCnt > 0 || extraCnt > 0) {
            this._status = true;
        }
    }
}

