/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.store;

import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.store.FilePersistenceStore;
import com.sun.enterprise.ee.synchronization.store.PersistenceStore;
import com.sun.enterprise.ee.synchronization.store.StoreException;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SynchronizationMemento {
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    PersistenceStore _store = new FilePersistenceStore();
    String _file = null;

    public SynchronizationMemento(SynchronizationResponse res) {
        SynchronizationRequest[] reply = res.getReply();
        assert (reply.length == 1);
        this._file = reply[0].getFileName();
    }

    public void saveState() throws StoreException {
        File f = new File(this._file);
        _logger.log(Level.FINER, "synchronization.save_momento", this._file);
        if (f.exists()) {
            this._store.save(this._file);
        }
    }

    public void rollback() throws StoreException {
        _logger.log(Level.FINER, "synchronization.rollback_momento", this._file);
        this._store.restore(this._file);
    }

    public void commit() throws StoreException {
        this.commitWithCopy();
    }

    private void commitWithCopy() throws StoreException {
        String dst = (String)((FilePersistenceStore)this._store).getBackupFileName(this._file);
        _logger.log(Level.FINER, "synchronization.commit_momento", this._file);
        File dstFile = new File(dst);
        if (dstFile.exists()) {
            FileUtils.liquidate((File)dstFile);
        } else {
            _logger.log(Level.FINEST, "synchronization.no_backup_dir", dst);
        }
    }

    private void commitWithMove() throws StoreException {
        String dst = (String)((FilePersistenceStore)this._store).getBackupFileName(this._file);
        _logger.log(Level.FINER, "synchronization.commit_momento", this._file);
        File newFile = new File(this._file);
        File dstFile = new File(dst);
        if (dstFile.exists()) {
            if (newFile.isDirectory()) {
                this._store.merge(dst, this._file);
            } else if (dstFile.isDirectory() && !newFile.exists()) {
                _logger.log(Level.FINEST, "synchronization.no_sync_file", newFile.getName());
                boolean ok = dstFile.renameTo(newFile);
                if (!ok) {
                    throw new StoreException();
                }
            } else if (dstFile.isFile() && !newFile.exists()) {
                _logger.log(Level.FINEST, "synchronization.no_sync_file", newFile.getName());
                boolean ok = dstFile.renameTo(newFile);
                if (!ok) {
                    throw new StoreException();
                }
            } else if (dstFile.isFile() && newFile.exists()) {
                FileUtils.liquidate((File)dstFile);
            }
        } else {
            _logger.log(Level.FINEST, "synchronization.no_backup_dir", dst);
        }
    }
}

