/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.util.concurrent;

import com.sun.enterprise.ee.synchronization.util.concurrent.Barrier;
import com.sun.enterprise.ee.synchronization.util.concurrent.BrokenBarrierException;
import com.sun.enterprise.ee.synchronization.util.concurrent.TimeoutException;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CyclicBarrier
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected Runnable barrierCommand_ = null;
    protected int count_;
    protected int resets_ = 0;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManagerBase _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    public CyclicBarrier(int parties, Runnable command) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = parties;
        this.count_ = parties;
        this.barrierCommand_ = command;
    }

    public synchronized Runnable setBarrierCommand(Runnable command) {
        Runnable old = this.barrierCommand_;
        this.barrierCommand_ = command;
        return old;
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    public synchronized void restart() {
        this.broken_ = false;
        ++this.resets_;
        this.count_ = this.parties_;
        this.notifyAll();
    }

    public int parties() {
        return this.parties_;
    }

    public int barrier() throws InterruptedException, BrokenBarrierException {
        return this.doBarrier(false, 0L);
    }

    public int attemptBarrier(long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doBarrier(true, msecs);
    }

    protected synchronized int doBarrier(boolean timed, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        int index = --this.count_;
        if (this.broken_) {
            throw new BrokenBarrierException(index);
        }
        if (Thread.interrupted()) {
            this.broken_ = true;
            this.notifyAll();
            throw new InterruptedException();
        }
        if (index == 0) {
            _logger.log(Level.FINE, _strMgr.getString("synchronization.util.concurrent.barrier_tripped", (Object)Thread.currentThread().getName()));
            this.count_ = this.parties_;
            ++this.resets_;
            this.notifyAll();
            try {
                if (this.barrierCommand_ != null) {
                    this.barrierCommand_.run();
                }
                return 0;
            }
            catch (RuntimeException ex) {
                this.broken_ = true;
                return 0;
            }
        }
        if (timed && msecs <= 0L) {
            this.broken_ = true;
            this.notifyAll();
            throw new TimeoutException(msecs);
        }
        int r = this.resets_;
        long startTime = timed ? System.currentTimeMillis() : 0L;
        long waitTime = msecs;
        do {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException ex) {
                if (this.resets_ == r) {
                    this.broken_ = true;
                    this.notifyAll();
                    throw ex;
                }
                Thread.currentThread().interrupt();
            }
            if (this.broken_) {
                throw new BrokenBarrierException(index);
            }
            if (r == this.resets_) continue;
            return index;
        } while (!timed || (waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
        this.broken_ = true;
        this.notifyAll();
        throw new TimeoutException(msecs);
    }
}

