/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.HATimeoutException;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Logger;

public class JxtaConnectErrorManager {
    private static Logger _logger = null;
    private long timeoutMsecs = 300000L;
    private long txStartTime;
    private long txDuration = 0L;
    private static final int TX_IDLE = 1;
    private static final int TX_STARTED = 2;
    private static final int TX_COMPLETED = 3;
    private int txState = 1;

    public JxtaConnectErrorManager(long timeoutSecs) {
        this.timeoutMsecs = timeoutSecs * 1000L;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public void checkError(IOException e) throws HATimeoutException {
        this.checkTimeouts();
    }

    protected void checkTimeouts() throws HATimeoutException {
        if (this.getElapsedTime() > this.timeoutMsecs) {
            System.out.println("JxtaConnectErrorManager:timeout:getElapsedTime=" + this.getElapsedTime() + " timeoutMsecs=" + this.timeoutMsecs);
            throw new HATimeoutException("Unable to complete a transaction after " + this.timeoutMsecs / 60000L + " minutes.");
        }
    }

    public synchronized void txStart() {
        if (this.txState != 2) {
            this.txState = 2;
            this.txStartTime = System.currentTimeMillis();
            this.txDuration = 0L;
        }
    }

    public void txEnd() {
        this.txState = 3;
        this.txDuration = System.currentTimeMillis() - this.txStartTime;
    }

    public boolean isTxCompleted() {
        return this.txState == 3;
    }

    public long getElapsedTime() {
        if (this.txState == 2) {
            return System.currentTimeMillis() - this.txStartTime;
        }
        if (this.txState == 3) {
            return this.txDuration;
        }
        return 0L;
    }
}

