/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.ha.spi.AttributeMetadata;
import com.sun.appserv.ha.spi.BackingStore;
import com.sun.appserv.ha.spi.BackingStoreException;
import com.sun.appserv.ha.spi.CompositeMetadata;
import com.sun.appserv.ha.spi.Metadata;
import com.sun.enterprise.ee.web.authenticator.ReplicationSingleSignOn;
import com.sun.enterprise.ee.web.sessmgmt.BaseHASession;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.HAStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreImpl;
import com.sun.enterprise.ee.web.sessmgmt.ModifiedAttributeHASession;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationStore;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import com.sun.web.security.RealmAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.session.StandardSession;

public class ReplicationAttributeStore
extends ReplicationStore
implements HAStorePoolElement {
    public static final String LOGGER_MEM_REP = "com.sun.enterprise.ee.web.sessmgmt";
    private static final Logger _logger = Logger.getLogger("com.sun.enterprise.ee.web.sessmgmt");
    protected static final String MODE_WEB = "web";
    protected static final String MESSAGE_QUERY_RESULT = "message_query_result";

    public ReplicationAttributeStore() {
        this.setLogLevel();
    }

    public void valveSave(Session session) throws IOException {
        HASession haSess = (HASession)session;
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doValveSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
    }

    public void save(Session session) throws IOException {
        HASession haSess = (HASession)session;
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
    }

    public void doValveSave(Session session) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>doValveSave:valid =" + ((StandardSession)session).getIsValid());
            _logger.fine("ReplicationAttributeStore>>valveSave:ssoId=" + ((HASession)session).getSsoId());
        }
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        ModifiedAttributeHASession modAttrSession = (ModifiedAttributeHASession)session;
        String userName = "";
        if (session.getPrincipal() != null) {
            userName = session.getPrincipal().getName();
            ((BaseHASession)session).setUserName(userName);
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getCompositeBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>save: replicator: " + replicator);
        }
        CompositeMetadata compositeMetadata = this.createCompositeMetadata(modAttrSession);
        try {
            replicator.save(session.getIdInternal(), (Metadata)compositeMetadata);
            modAttrSession.resetAttributeState();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public void doSave(Session session) throws IOException {
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        ModifiedAttributeHASession modAttrSession = (ModifiedAttributeHASession)session;
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getCompositeBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>doSave: replicator: " + replicator);
        }
        CompositeMetadata compositeMetadata = this.createCompositeMetadata(modAttrSession);
        try {
            replicator.save(session.getIdInternal(), (Metadata)compositeMetadata);
            modAttrSession.resetAttributeState();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public Session load(String id) throws ClassNotFoundException, IOException {
        return this.load(id, null);
    }

    public Session load(String id, String version) throws ClassNotFoundException, IOException {
        Session result = null;
        if (id == null) {
            return result;
        }
        ReplicationManagerBase repMgr = (ReplicationManagerBase)this.getManager();
        ReplicationState localCachedState = repMgr.transferFromReplicationCache(id);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>load:localCachedState=" + localCachedState);
        }
        if (version != null && localCachedState != null) {
            long versionLong = this.parseLong(version);
            if (localCachedState.getVersion() == versionLong) {
                return this.getSession(localCachedState);
            }
        }
        ReplicationState broadcastResultState = this.findSessionViaBroadcast(id, version);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>load:broadcastResultState from broadcast=" + broadcastResultState);
        }
        if (broadcastResultState != null) {
            // empty if block
        }
        ReplicationState bestState = this.getBestResult(localCachedState, broadcastResultState);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>load:bestState=" + bestState);
        }
        if (bestState != null) {
            // empty if block
        }
        if (bestState != null && bestState.getState() != null && bestState.getTrunkState() != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationAttributeStore>>load:before deserializing bestState:ver=" + bestState.getVersion());
            }
            result = this.getSession(bestState);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationAttributeStore>>load:after deserializing session:ver=" + ((HASession)result).getVersion());
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>load:id " + id + " session: " + result);
        }
        if (result != null) {
            ((HASession)result).setDirty(false);
            ((HASession)result).setPersistent(false);
        }
        return result;
    }

    private ReplicationState findSessionViaBroadcast(String id, String version) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>findSessionViaBroadcast");
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getCompositeBackingStore();
        JxtaBackingStoreImpl jxtaReplicator = null;
        if (replicator instanceof JxtaBackingStoreImpl) {
            jxtaReplicator = (JxtaBackingStoreImpl)replicator;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>findSessionViaBroadcast: replicator: " + replicator);
        }
        CompositeMetadata queryResult = null;
        try {
            queryResult = jxtaReplicator != null && version != null ? (CompositeMetadata)jxtaReplicator.load(id, version) : (CompositeMetadata)replicator.load(id);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (queryResult == null) {
            return null;
        }
        ReplicationState result = this.createReplicationStateFrom(id, queryResult, MESSAGE_QUERY_RESULT);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getSession(ReplicationState replicationState) throws IOException, ClassNotFoundException {
        long version;
        String ssoId;
        Principal pal;
        Container container;
        Session _session;
        block26: {
            byte[] state = replicationState.getTrunkState();
            _session = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            container = this.manager.getContainer();
            pal = null;
            ssoId = null;
            version = 0L;
            IOUtilsCaller utilsCaller = null;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                String id = (String)replicationState.getId();
                ssoId = replicationState.getExtraParam();
                version = replicationState.getVersion();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("loaded session from replicationstore, length = " + state.length);
                }
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null && (utilsCaller = this.getWebUtilsCaller()) != null) {
                    try {
                        ois = utilsCaller.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block26;
                try {
                    _session = this.readSession(this.manager, ois);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("getSession :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        String username = ((HASession)_session).getUserName();
        if (username != null && !username.equals("") && _session.getPrincipal() == null) {
            if (this._debug > 0) {
                this.debug("Username retrieved is " + username);
            }
            pal = ((RealmAdapter)container.getRealm()).createFailOveredPrincipal(username);
            if (this._debug > 0) {
                this.debug("principal created using username  " + pal);
            }
            if (pal != null) {
                _session.setPrincipal(pal);
                if (this._debug > 0) {
                    this.debug("getSession principal=" + pal + " was added to session=" + _session);
                }
            }
        }
        _session.setNew(false);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>ssoId=" + ssoId);
        }
        ((BaseHASession)_session).setSsoId(ssoId);
        if (ssoId != null && !ssoId.equals("")) {
            this.associate(ssoId, _session);
        }
        ((HASession)_session).setVersion(version);
        ((HASession)_session).setDirty(false);
        ((ModifiedAttributeHASession)_session).clearAttributeStates();
        byte[] entriesState = replicationState.getState();
        Collection entries = null;
        if (entriesState != null) {
            entries = this.deserializeStatesCollection(entriesState);
            this.loadAttributes((ModifiedAttributeHASession)_session, entries);
        }
        return _session;
    }

    protected void associate(String ssoId, Session _session) {
        if (this._debug > 0) {
            this.debug("Inside associate() -- HAStore");
        }
        Container parent = this.manager.getContainer();
        SingleSignOn sso = null;
        while (sso == null && parent != null) {
            if (this._debug > 0) {
                this.debug("Inside associate()  while loop -- HAStore");
            }
            if (!(parent instanceof Pipeline)) {
                if (this._debug > 0) {
                    this.debug("Inside associate()  parent instanceof Pipeline -- HAStore");
                }
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)parent).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                if (this._debug > 0) {
                    this.debug("Inside associate()  valves[i] instanceof SingleSignOn -- HAStore");
                }
                sso = (SingleSignOn)valves[i];
                break;
            }
            if (sso != null) continue;
            parent = parent.getParent();
        }
        if (sso != null) {
            if (this._debug > 0) {
                this.debug("Inside associate() sso != null");
            }
            SingleSignOnEntry ssoEntry = ((ReplicationSingleSignOn)sso).lookupEntry(ssoId);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Inside associate() ssoEntry = " + ssoEntry);
            }
            if (ssoEntry != null) {
                ssoEntry.addSession(sso, _session);
            }
        }
    }

    private void postSaveUpdate(ModifiedAttributeHASession modAttrSession) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>postSaveUpdate");
        }
        ArrayList addedAttrs = modAttrSession.getAddedAttributes();
        ArrayList modifiedAttrs = modAttrSession.getModifiedAttributes();
        ArrayList deletedAttrs = modAttrSession.getDeletedAttributes();
        this.postProcessSetAttrStates(modAttrSession, addedAttrs);
        this.postProcessSetAttrStates(modAttrSession, modifiedAttrs);
    }

    private void postProcessSetAttrStates(ModifiedAttributeHASession modAttrSession, ArrayList attrsList) {
        for (int i = 0; i < attrsList.size(); ++i) {
            String nextStateName = (String)attrsList.get(i);
            modAttrSession.setAttributeStatePersistent(nextStateName, true);
            modAttrSession.setAttributeStateDirty(nextStateName, false);
        }
    }

    private CompositeMetadata createCompositeMetadata(ModifiedAttributeHASession modAttrSession) {
        byte[] trunkState = null;
        try {
            trunkState = this.getByteArray(modAttrSession);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>createCompositeMetadata:trunkState=" + trunkState);
        }
        ArrayList entries = new ArrayList();
        ArrayList addedAttrs = modAttrSession.getAddedAttributes();
        ArrayList modifiedAttrs = modAttrSession.getModifiedAttributes();
        ArrayList deletedAttrs = modAttrSession.getDeletedAttributes();
        this.addToEntries(modAttrSession, entries, AttributeMetadata.Operation.ADD, addedAttrs);
        this.addToEntries(modAttrSession, entries, AttributeMetadata.Operation.UPDATE, modifiedAttrs);
        entries = this.addToEntries(modAttrSession, entries, AttributeMetadata.Operation.DELETE, deletedAttrs);
        CompositeMetadata result = new CompositeMetadata(modAttrSession.getVersion(), modAttrSession.getLastAccessedTimeInternal(), (long)modAttrSession.getMaxInactiveInterval(), (Collection)entries, trunkState, modAttrSession.getSsoId());
        return result;
    }

    private void printAttrList(String attrListType, ArrayList attrList) {
        System.out.println("AttributeType = " + attrListType + "\n");
        String nextAttrName = null;
        for (int i = 0; i < attrList.size(); ++i) {
            nextAttrName = (String)attrList.get(i);
            System.out.println("attribute[" + i + "]=" + nextAttrName + "\n");
        }
    }

    private ArrayList addToEntries(ModifiedAttributeHASession modAttrSession, ArrayList entries, AttributeMetadata.Operation op, ArrayList attrList) {
        String nextAttrName = null;
        Object nextAttrValue = null;
        byte[] nextValue = null;
        for (int i = 0; i < attrList.size(); ++i) {
            nextAttrName = (String)attrList.get(i);
            nextAttrValue = modAttrSession.getAttribute(nextAttrName);
            nextValue = null;
            try {
                nextValue = this.getByteArray(nextAttrValue);
            }
            catch (IOException ex) {
                // empty catch block
            }
            AttributeMetadata nextAttrMetadata = new AttributeMetadata(nextAttrName, op, nextValue);
            entries.add(nextAttrMetadata);
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArray(Object attributeValue) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        IOUtilsCaller utilsCaller = null;
        try {
            bos = new ByteArrayOutputStream();
            utilsCaller = this.getWebUtilsCaller();
            if (utilsCaller != null) {
                try {
                    oos = utilsCaller.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            oos.writeObject(attributeValue);
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAttributeValue(byte[] state) throws IOException, ClassNotFoundException {
        Object attributeValue;
        block17: {
            attributeValue = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            Container container = this.manager.getContainer();
            IOUtilsCaller utilsCaller = null;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null && (utilsCaller = this.getWebUtilsCaller()) != null) {
                    try {
                        ois = utilsCaller.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block17;
                try {
                    attributeValue = ois.readObject();
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("getAttributeValue :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return attributeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArrayFromCollection(Collection entries) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        IOUtilsCaller utilsCaller = null;
        try {
            bos = new ByteArrayOutputStream();
            utilsCaller = this.getWebUtilsCaller();
            if (utilsCaller != null) {
                try {
                    oos = utilsCaller.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            int entriesSize = entries.size();
            oos.writeObject(entriesSize);
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                oos.writeObject(it.next());
            }
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAttributeValueCollection(byte[] state) throws IOException, ClassNotFoundException {
        ArrayList<Object> attributeValueList;
        block19: {
            attributeValueList = new ArrayList<Object>();
            Object attributeValue = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            Container container = this.manager.getContainer();
            IOUtilsCaller utilsCaller = null;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null && (utilsCaller = this.getWebUtilsCaller()) != null) {
                    try {
                        ois = utilsCaller.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block19;
                try {
                    Object whatIsIt = ois.readObject();
                    int entriesSize = 0;
                    if (whatIsIt instanceof Integer) {
                        entriesSize = (Integer)whatIsIt;
                    }
                    for (int i = 0; i < entriesSize; ++i) {
                        Object nextAttributeValue = ois.readObject();
                        attributeValueList.add(nextAttributeValue);
                    }
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("getAttributeValue :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return attributeValueList;
    }

    protected void loadAttributes(ModifiedAttributeHASession modifiedAttributeSession, Collection attributeList) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in loadAttributes -- ReplicationAttributeStore : session id=" + modifiedAttributeSession.getIdInternal());
        }
        String thisAttrName = null;
        AttributeMetadata.Operation thisAttrOp = null;
        Object thisAttrVal = null;
        for (AttributeMetadata nextAttrMetadata : attributeList) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("IN loadAttributes:while loop");
            }
            thisAttrName = nextAttrMetadata.getAttributeName();
            thisAttrOp = nextAttrMetadata.getOperation();
            byte[] nextAttrState = nextAttrMetadata.getState();
            thisAttrVal = null;
            try {
                thisAttrVal = this.getAttributeValue(nextAttrState);
            }
            catch (ClassNotFoundException ex1) {
            }
            catch (IOException ex2) {
                // empty catch block
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Attr retrieved======" + thisAttrName);
            }
            if (thisAttrVal == null) continue;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Setting Attribute: " + thisAttrName);
            }
            modifiedAttributeSession.setAttribute(thisAttrName, thisAttrVal);
            modifiedAttributeSession.setAttributeStatePersistent(thisAttrName, false);
            modifiedAttributeSession.setAttributeStateDirty(thisAttrName, false);
        }
    }

    ModifiedAttributeHASession createSession(String id, CompositeMetadata compositeMetadata) {
        ModifiedAttributeHASession theSession = (ModifiedAttributeHASession)((ReplicationManagerBase)this.manager).createSession();
        theSession.setId(id);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in getSession -- ReplicationAttributeStore : id =" + id);
        }
        theSession.setValid(true);
        theSession.setVersion(compositeMetadata.getVersion());
        theSession.setMaxInactiveInterval((int)compositeMetadata.getMaxInactiveInterval());
        theSession.setLastAccessedTime(compositeMetadata.getLastAccessTime());
        theSession.setSsoId(compositeMetadata.getExtraParam());
        this.loadAttributes(theSession, compositeMetadata.getEntries());
        return theSession;
    }

    private ReplicationState createReplicationStateFrom(String id, CompositeMetadata compositeMetadata, String command) {
        ReplicationState result = new ReplicationState(MODE_WEB, id, this.getApplicationId(), compositeMetadata.getVersion(), compositeMetadata.getLastAccessTime(), compositeMetadata.getMaxInactiveInterval(), compositeMetadata.getExtraParam(), null, null, command, this.serializeStatesCollection(compositeMetadata.getEntries()), compositeMetadata.getState());
        return result;
    }

    private byte[] serializeStatesCollection(Collection entries) {
        byte[] result = null;
        try {
            result = this.getByteArrayFromCollection(entries);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private byte[] serializeStatesCollectionPrevious(Collection entries) {
        byte[] result = null;
        try {
            result = this.getByteArray(entries);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private CompositeMetadata createCompositeMetadataFrom(ReplicationState state) {
        Collection entries = this.deserializeStatesCollection(state.getState());
        CompositeMetadata result = new CompositeMetadata(state.getVersion(), state.getLastAccess(), state.getMaxInactiveInterval(), entries, state.getTrunkState(), state.getExtraParam());
        return result;
    }

    private Collection deserializeStatesCollection(byte[] entriesState) {
        Collection result = new ArrayList();
        try {
            result = (Collection)this.getAttributeValueCollection(entriesState);
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private Collection deserializeStatesCollectionPrevious(byte[] entriesState) {
        Collection result = new ArrayList();
        try {
            result = (Collection)this.getAttributeValue(entriesState);
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

