/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.ha.spi.BackingStore;
import com.sun.appserv.ha.spi.BackingStoreException;
import com.sun.appserv.ha.spi.Metadata;
import com.sun.appserv.ha.spi.SimpleMetadata;
import com.sun.appserv.util.cache.BaseCache;
import com.sun.enterprise.ee.web.authenticator.ReplicationSingleSignOn;
import com.sun.enterprise.ee.web.sessmgmt.BaseHASession;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.HAStoreBase;
import com.sun.enterprise.ee.web.sessmgmt.HAStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreImpl;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationReceiver;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationSender;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import com.sun.web.security.RealmAdapter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.session.StandardSession;

public class ReplicationStore
extends HAStoreBase
implements HAStorePoolElement {
    public static final String LOGGER_MEM_REP = "com.sun.enterprise.ee.web.sessmgmt";
    private static final Logger _logger = Logger.getLogger("com.sun.enterprise.ee.web.sessmgmt");
    protected static final String MODE_WEB = "web";

    public ReplicationStore() {
        this.setLogLevel();
    }

    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        this.applicationId = "WEB:" + super.getApplicationId();
        return this.applicationId;
    }

    public void valveSave(Session session) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>valveSave");
        }
        HASession haSess = (HASession)session;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>valveSave:haSess isPersistent" + haSess.isPersistent());
            _logger.fine("ReplicationStore>>valveSave:haSess isDirty" + haSess.isDirty());
        }
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doValveSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
    }

    public void doValveSave(Session session) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doValveSave:id =" + ((HASession)session).getIdInternal());
            _logger.fine("ReplicationStore>>doValveSave:valid =" + ((StandardSession)session).getIsValid());
            _logger.fine("ReplicationStore>>doValveSave:ssoId=" + ((HASession)session).getSsoId());
        }
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        String userName = "";
        if (session.getPrincipal() != null) {
            userName = session.getPrincipal().getName();
            ((BaseHASession)session).setUserName(userName);
        }
        byte[] sessionState = this.getByteArray(session);
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doValveSave replicator: " + replicator);
            _logger.fine("ReplicationStore>>doValveSave version:" + ((HASession)session).getVersion());
        }
        SimpleMetadata simpleMetadata = new SimpleMetadata(((HASession)session).getVersion(), ((BaseHASession)session).getLastAccessedTimeInternal(), (long)session.getMaxInactiveInterval(), sessionState, ((HASession)session).getSsoId());
        try {
            replicator.save(session.getIdInternal(), (Metadata)simpleMetadata);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public void sendResponse(ReplicationState state) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>sendResponse");
        }
        this.doReturnTransmit(state);
    }

    public void sendQueryResponse(ReplicationState state, String returnInstance) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>sendQueryResponse");
        }
        this.doReturnQueryTransmit(state, returnInstance);
    }

    protected void transmitSession(Session session, String command) throws IOException {
        ReplicationState transmitState = this.createReplicationState(session, command);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>transmitSession: command: " + command);
        }
        this.doTransmit(transmitState);
    }

    protected void transmitSession(Session session, String command, boolean wait) throws IOException {
        ReplicationState transmitState = this.createReplicationState(session, command);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>transmitSession: command: " + command);
        }
        this.doTransmit(transmitState, wait);
    }

    private boolean isMethodVoidReturn(String methodName) {
        return ReplicationState.isMethodVoidReturn(methodName);
    }

    protected ReplicationState createReplicationState(Session session, String command) throws IOException {
        byte[] sessionState = this.getByteArray(session);
        ReplicationState transmitState = new ReplicationState(MODE_WEB, session.getIdInternal(), this.getApplicationId(), ((HASession)session).getVersion(), ((BaseHASession)session).getLastAccessedTimeInternal(), session.getMaxInactiveInterval(), this.getSsoId((StandardSession)session), null, null, command, sessionState, null);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>createReplicationState:transmitState = " + transmitState);
        }
        return transmitState;
    }

    private void testDeserializeState(ReplicationState transmitState) {
        try {
            Session sess = this.getSession(transmitState);
            System.out.println("sess = " + sess);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanup() {
    }

    public BaseCache getSessions() {
        return null;
    }

    public void setSessions(BaseCache sesstable) {
    }

    public void save(Session session) throws IOException {
        HASession haSess = (HASession)session;
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
    }

    public void doSave(Session session) throws IOException {
        byte[] sessionState = this.getByteArray(session);
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>save: replicator: " + replicator);
        }
        SimpleMetadata simpleMetadata = new SimpleMetadata(((HASession)session).getVersion(), ((BaseHASession)session).getLastAccessedTimeInternal(), (long)session.getMaxInactiveInterval(), sessionState, ((HASession)session).getSsoId());
        try {
            replicator.save(session.getIdInternal(), (Metadata)simpleMetadata);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public synchronized void clear() throws IOException {
    }

    public void doRemove(String id) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doRemove");
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>doRemove: replicator: " + replicator);
        }
        try {
            replicator.remove(id);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public synchronized void removeSynchronized(String id) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeSynchronized");
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeSynchronized: replicator: " + replicator);
        }
        try {
            replicator.remove(id);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public void removeIds(long msgID, byte[] removedIdsData) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeIds");
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        JxtaBackingStoreImpl replicator = (JxtaBackingStoreImpl)mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>removeIds: replicator: " + (Object)((Object)replicator));
        }
        try {
            replicator.removeIds(msgID, removedIdsData);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public void processExpires() {
        ReplicationManagerBase replicationMgr = (ReplicationManagerBase)this.getManager();
        replicationMgr.processExpiredReplicas();
    }

    protected ReplicationState doTransmit(ReplicationState transmitState) {
        return this.doTransmit(transmitState, true);
    }

    protected ReplicationState doTransmit(ReplicationState transmitState, boolean wait) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationState(transmitState, wait);
        return resultState;
    }

    protected ReplicationState doReturnTransmit(ReplicationState transmitState) {
        JxtaReplicationReceiver replicationReceiver = JxtaReplicationReceiver.createInstance();
        ReplicationState resultState = replicationReceiver.sendReplicationStateResponse(transmitState);
        return resultState;
    }

    protected ReplicationState doReturnQueryTransmit(ReplicationState transmitState, String returnInstance) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationStateQueryResponse(transmitState, returnInstance);
        return resultState;
    }

    public Session load(String id) throws ClassNotFoundException, IOException {
        return this.load(id, null);
    }

    public Session load(String id, String version) throws ClassNotFoundException, IOException {
        Session result = null;
        if (id == null) {
            return result;
        }
        ReplicationManagerBase repMgr = (ReplicationManagerBase)this.getManager();
        if (_logger.isLoggable(Level.FINE)) {
            repMgr.printReplicatedSessionIds();
        }
        long startTime = System.currentTimeMillis();
        ReplicationState localCachedState = repMgr.transferFromReplicationCache(id);
        _logger.log(Level.INFO, "transferFromReplicationCache for id: " + id + " took: " + (System.currentTimeMillis() - startTime) + " ms");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>load:localCachedState=" + localCachedState);
        }
        _logger.log(Level.INFO, "ReplicationStore>>load:localCachedState=" + localCachedState);
        if (version != null && localCachedState != null) {
            long versionLong = this.parseLong(version);
            if (localCachedState.getVersion() == versionLong) {
                return this.getSession(localCachedState);
            }
        }
        long startTime2 = System.currentTimeMillis();
        ReplicationState broadcastResultState = this.findSessionViaBroadcast(id, version);
        _logger.log(Level.INFO, "findSessionViaBroadcast for id: " + id + " took: " + (System.currentTimeMillis() - startTime2) + " ms");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>load:broadcastResultState from broadcast=" + broadcastResultState);
        }
        ReplicationState bestState = this.getBestResult(localCachedState, broadcastResultState);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>load:bestState=" + bestState);
        }
        if (bestState != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>load:bestStateVERSION=" + bestState.getVersion());
            _logger.fine("ReplicationStore>>load:bestStateSTATE=" + bestState.getState());
        }
        if (bestState != null && bestState.getState() != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationStore>>load:before deserializing bestState:ver=" + bestState.getVersion());
            }
            result = this.getSession(bestState);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationStore>>load:after deserializing session:ver=" + ((HASession)result).getVersion());
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>load:id " + id + " session: " + result);
        }
        return result;
    }

    protected ReplicationState getBestResult(ReplicationState localState, ReplicationState broadcastResultState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>getBestResult:localState=" + localState + "other=" + broadcastResultState);
        }
        if (localState == null) {
            return broadcastResultState;
        }
        if (broadcastResultState == null) {
            return localState;
        }
        if (broadcastResultState.getVersion() >= localState.getVersion()) {
            return broadcastResultState;
        }
        return localState;
    }

    private ReplicationState findSessionViaBroadcast(String id, String version) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>findSessionViaBroadcast");
        }
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        JxtaBackingStoreImpl jxtaReplicator = null;
        if (replicator instanceof JxtaBackingStoreImpl) {
            jxtaReplicator = (JxtaBackingStoreImpl)replicator;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>findSessionViaBroadcast: replicator: " + replicator);
        }
        SimpleMetadata queryResult = null;
        try {
            queryResult = jxtaReplicator != null && version != null ? (SimpleMetadata)jxtaReplicator.load(id, version) : (SimpleMetadata)replicator.load(id);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (queryResult == null) {
            return null;
        }
        ReplicationState result = new ReplicationState(MODE_WEB, id, this.getApplicationId(), queryResult.getVersion(), 0L, 0L, null, queryResult.getExtraParam(), null, null, queryResult.getState(), null);
        return result;
    }

    protected long parseLong(String s) {
        long result = -1L;
        try {
            result = Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        return result;
    }

    public void updateLastAccessTime(Session session) throws IOException {
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>updateLastAccessTime: replicator: " + replicator);
        }
        try {
            replicator.updateLastAccessTime(session.getIdInternal(), ((BaseHASession)session).getLastAccessedTimeInternal(), ((HASession)session).getVersion());
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public String[] keys() throws IOException {
        return new String[0];
    }

    public int getSize() throws IOException {
        int result = 0;
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        BackingStore replicator = mgr.getBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>getSize: replicator: " + replicator);
        }
        try {
            result = replicator.size();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getSession(ReplicationState replicationState) throws IOException, ClassNotFoundException {
        long version;
        String ssoId;
        Principal pal;
        Container container;
        Session _session;
        block27: {
            byte[] state = replicationState.getState();
            _session = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            container = this.manager.getContainer();
            pal = null;
            ssoId = null;
            version = 0L;
            IOUtilsCaller utilsCaller = null;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                String id = (String)replicationState.getId();
                ssoId = replicationState.getExtraParam();
                version = replicationState.getVersion();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("loaded session from replicationstore, length = " + state.length);
                }
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null && (utilsCaller = this.getWebUtilsCaller()) != null) {
                    try {
                        ois = utilsCaller.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block27;
                try {
                    _session = this.readSession(this.manager, ois);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("getSession :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        String username = ((HASession)_session).getUserName();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>getSession: username=" + username);
            _logger.fine("ReplicationStore>>getSession: principal=" + _session.getPrincipal());
        }
        if (username != null && !username.equals("") && _session.getPrincipal() == null) {
            if (this._debug > 0) {
                this.debug("Username retrieved is " + username);
            }
            pal = ((RealmAdapter)container.getRealm()).createFailOveredPrincipal(username);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationStore>>getSession:created pal=" + pal);
            }
            if (this._debug > 0) {
                this.debug("principal created using username  " + pal);
            }
            if (pal != null) {
                _session.setPrincipal(pal);
                if (this._debug > 0) {
                    this.debug("getSession principal=" + pal + " was added to session=" + _session);
                }
            }
        }
        _session.setNew(false);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationStore>>getSession:ssoId=" + ssoId);
        }
        ((BaseHASession)_session).setSsoId(ssoId);
        if (ssoId != null && !ssoId.equals("")) {
            this.associate(ssoId, _session);
        }
        ((HASession)_session).setVersion(version);
        ((HASession)_session).setDirty(false);
        ((HASession)_session).setPersistent(false);
        return _session;
    }

    protected void associate(String ssoId, Session _session) {
        if (this._debug > 0) {
            this.debug("Inside associate() -- HAStore");
        }
        Container parent = this.manager.getContainer();
        SingleSignOn sso = null;
        while (sso == null && parent != null) {
            if (this._debug > 0) {
                this.debug("Inside associate()  while loop -- HAStore");
            }
            if (!(parent instanceof Pipeline)) {
                if (this._debug > 0) {
                    this.debug("Inside associate()  parent instanceof Pipeline -- HAStore");
                }
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)parent).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                if (this._debug > 0) {
                    this.debug("Inside associate()  valves[i] instanceof SingleSignOn -- HAStore");
                }
                sso = (SingleSignOn)valves[i];
                break;
            }
            if (sso != null) continue;
            parent = parent.getParent();
        }
        if (sso != null) {
            if (this._debug > 0) {
                this.debug("Inside associate() sso != null");
            }
            SingleSignOnEntry ssoEntry = ((ReplicationSingleSignOn)sso).lookupEntry(ssoId);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("ReplicationStore>>associate: ssoEntry = " + ssoEntry);
                _logger.finest("ReplicationStore>>associate: ssoEntry.principal = " + ssoEntry.principal + "_session.getPrincipal() =" + _session.getPrincipal());
            }
            if (ssoEntry != null) {
                ssoEntry.addSession(sso, _session);
                if (ssoEntry.principal == null && _session.getPrincipal() != null) {
                    ssoEntry.principal = _session.getPrincipal();
                }
            }
        }
    }

    protected String getUsername(StandardSession session) {
        String result = null;
        result = session.getPrincipal() != null ? session.getPrincipal().getName() : "";
        return result;
    }

    protected String getSsoId(StandardSession session) {
        return ((HASession)session).getSsoId();
    }
}

