/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.AbstractXAResourceType;
import com.sun.genericra.XAResourceType;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class InboundXAResourceProxy
extends AbstractXAResourceType {
    private XAResource xar = null;
    private boolean toRollback = true;
    private boolean rolledback = false;
    private boolean suspended = false;
    private boolean endCalled = false;
    private static Logger logger = LogUtils.getLogger();
    private Xid startXid = null;
    private int startflags;
    private boolean startedDelayedXA = false;

    public InboundXAResourceProxy(XAResource xar) {
        this.xar = xar;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.debugxid("Commiting inbound transaction with ID ", xid);
        if (xid != null) {
            this.debugxid("Committed inbound transaction with ID ", xid);
            this.xar.commit(xid, onePhase);
        } else {
            this.debugxid("Committed inbound transaction with ID ", this.startXid);
            this.xar.commit(this.startXid, onePhase);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.debugxid("Ending inbound transaction with ID ", xid);
        if (xid == null) {
            xid = this.startXid;
        }
        if (this.startedDelayedXA && !this.endCalled) {
            this.debugxid("Ended inbound transaction with ID ", xid);
            this.endCalled = true;
            this.xar.end(xid, flags);
        }
    }

    private boolean beingRedelivered() {
        return this.endCalled && !this.suspended;
    }

    public void forget(Xid xid) throws XAException {
        this.xar.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xar.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        XAResource inxa = xares;
        if (xares instanceof XAResourceType) {
            XAResourceType wrapper = (XAResourceType)((Object)xares);
            inxa = (XAResource)wrapper.getWrappedObject();
            if (!this.compare(wrapper)) {
                return false;
            }
        }
        return this.xar.isSameRM(inxa);
    }

    public int prepare(Xid xid) throws XAException {
        this.debugxid("Preparing inbound transaction with ID ", xid);
        if (xid == null) {
            this.debugxid("Prepared inbound transactionw with ID ", this.startXid);
            return this.xar.prepare(this.startXid);
        }
        this.debugxid("Prepared inbound transactionw with ID ", xid);
        return this.xar.prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.xar.recover(flag);
    }

    public void rollback(Xid xid) throws XAException {
        this.debugxid("Rolling back inbound transaction with ID ", xid);
        if (this.toRollback) {
            this.xar.rollback(xid);
            this.debugxid("Rolled back transaction with ID ", xid);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xar.setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.startedDelayedXA) {
            this.debugxid("Delayed start of inbound transaction with ID ", this.startXid);
            this.xar.start(xid, flags);
        } else {
            this.startXid = xid;
            if (flags != 0x8000000) {
                this.startflags = flags;
            }
        }
    }

    public Object getWrappedObject() {
        return this.xar;
    }

    public void setToRollback(boolean flag) {
        this.toRollback = flag;
    }

    public boolean endCalled() {
        return this.endCalled;
    }

    public void startDelayedXA() {
        try {
            this.debugxid("Delayed start of inboudn transaction (in startDelated) ", this.startXid);
            this.xar.start(this.startXid, this.startflags);
        }
        catch (XAException xae) {
            xae.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.startedDelayedXA = true;
    }

    void debug(String s) {
        logger.log(Level.FINEST, "InboundXAResourceProxy : " + s);
    }

    void debugxid(String s, Xid xid) {
        if (logger.getLevel() == Level.FINEST) {
            logger.log(Level.FINEST, s + this.printXid(xid));
        }
    }
}

