/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.monitoring;

import com.sun.genericra.inbound.InboundJmsResourcePool;

public class PoolStatistics {
    private InboundJmsResourcePool pool;
    private static String MAX_SIZE = "Maximum Size of the pool";
    private static String MAX_WAIT_TIME = "Maximum wait time to queue the request for a resource";
    private static String CURRENT_RESOURCES = "No of resources in the pool (FREE + BUSY)";
    private static String BUSY_RESOURCES = "No of resources busy";
    private static String FREE_RESOURCES = "No of free resources";
    private static String CONNECTIONS_IN_USE = "No of connections being used ";
    private static String REQUESTS_WAITING = "No of requests waiting for resource";
    private static String SEPARATOR = " : ";
    private static String NEW_LINE = "\n";

    public PoolStatistics(InboundJmsResourcePool pool) {
        this.pool = pool;
    }

    public void setPool(InboundJmsResourcePool pool) {
        this.pool = pool;
    }

    private int getCurrentSize() {
        return this.pool.getCurrentResources();
    }

    private int getBusyResources() {
        return this.pool.getBusyResources();
    }

    private int getFreeResources() {
        return this.pool.getFreeResources();
    }

    private int getWaiting() {
        return this.pool.getWaiting();
    }

    private int getConnections() {
        return this.pool.getConnectionsInUse();
    }

    private int getMaxSize() {
        return this.pool.getMaxSize();
    }

    private long getMaxWaitTime() {
        return this.pool.getMaxWaitTime();
    }

    public String formatStatistics() {
        StringBuffer output = new StringBuffer();
        output.append(MAX_SIZE);
        output.append(SEPARATOR);
        output.append(this.getMaxSize());
        output.append(NEW_LINE);
        output.append(MAX_WAIT_TIME);
        output.append(SEPARATOR);
        output.append(this.getMaxWaitTime());
        output.append(NEW_LINE);
        output.append(CONNECTIONS_IN_USE);
        output.append(SEPARATOR);
        output.append(this.getConnections());
        output.append(NEW_LINE);
        output.append(CURRENT_RESOURCES);
        output.append(SEPARATOR);
        output.append(this.getCurrentSize());
        output.append(NEW_LINE);
        output.append(BUSY_RESOURCES);
        output.append(SEPARATOR);
        output.append(this.getBusyResources());
        output.append(NEW_LINE);
        output.append(FREE_RESOURCES);
        output.append(SEPARATOR);
        output.append(this.getFreeResources());
        output.append(NEW_LINE);
        output.append(REQUESTS_WAITING);
        output.append(SEPARATOR);
        output.append(this.getWaiting());
        output.append(NEW_LINE);
        return output.toString();
    }
}

