/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class LineNumberTableAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "LineNumberTable";
    private short[] lineNumbers;
    private InsnTarget[] targets;

    public LineNumberTableAttribute(ConstUtf8 nameAttr, short[] lineNums, InsnTarget[] targets) {
        super(nameAttr);
        this.lineNumbers = lineNums;
        this.targets = targets;
    }

    static LineNumberTableAttribute read(ConstUtf8 attrName, DataInputStream data, CodeEnv env) throws IOException {
        int nLnums = data.readUnsignedShort();
        short[] lineNums = new short[nLnums];
        InsnTarget[] targs = new InsnTarget[nLnums];
        for (int i = 0; i < nLnums; ++i) {
            targs[i] = env.getTarget(data.readShort());
            lineNums[i] = data.readShort();
        }
        return new LineNumberTableAttribute(attrName, lineNums, targs);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        int nlines = this.lineNumbers.length;
        out.writeInt(2 + 4 * nlines);
        out.writeShort(nlines);
        for (int i = 0; i < nlines; ++i) {
            out.writeShort(this.targets[i].offset());
            out.writeShort(this.lineNumbers[i]);
        }
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("Line Numbers: ");
        for (int i = 0; i < this.lineNumbers.length; ++i) {
            ClassPrint.spaces(out, indent + 2);
            out.println(Integer.toString(this.lineNumbers[i]) + " @ " + Integer.toString(this.targets[i].offset()));
        }
    }
}

