/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.server.PersistenceUnitInfoImpl;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.BaseProcessor;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceProcessor
extends BaseProcessor {
    private static final String TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD = "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider";
    private static final String TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW = "oracle.toplink.essentials.PersistenceProvider";
    private PersistenceUnitInfo pi;

    public PersistenceProcessor(DeploymentEventInfo info, boolean create, String cliCreateTables, String cliDropAndCreateTables, String cliDropTables) {
        super(info, create, cliCreateTables, cliDropAndCreateTables, cliDropTables);
    }

    @Override
    protected void processApplication() {
        Collection<PersistenceUnitDescriptor> pus = this.getAllPersistenceUnitDescriptors(this.application);
        if (pus.size() == 0) {
            return;
        }
        this.setApplicationLocation();
        this.setGeneratedLocation();
        for (PersistenceUnitDescriptor pu : pus) {
            this.processAppBundle(pu);
        }
    }

    private Collection<PersistenceUnitDescriptor> getAllPersistenceUnitDescriptors(Application application) {
        EjbBundleDescriptor bundle;
        HashSet<PersistenceUnitDescriptor> allPUs = new HashSet<PersistenceUnitDescriptor>();
        for (Object o : application.getEjbBundleDescriptors()) {
            bundle = (EjbBundleDescriptor)EjbBundleDescriptor.class.cast(o);
            allPUs.addAll(bundle.findReferencedPUs());
        }
        for (Object o : application.getWebBundleDescriptors()) {
            bundle = (WebBundleDescriptor)WebBundleDescriptor.class.cast(o);
            allPUs.addAll(bundle.findReferencedPUs());
        }
        for (Object o : application.getApplicationClientDescriptors()) {
            bundle = (ApplicationClientDescriptor)ApplicationClientDescriptor.class.cast(o);
            allPUs.addAll(bundle.findReferencedPUs());
        }
        return allPUs;
    }

    private void processAppBundle(PersistenceUnitDescriptor bundle) {
        String ddlGenerate = this.getPersistencePropVal(bundle, "toplink.ddl-generation", "none");
        String ddlMode = this.getPersistencePropVal(bundle, "toplink.ddl-generation.output-mode", "both");
        boolean createTables = this.getCreateTablesValue(ddlGenerate, ddlMode);
        boolean dropTables = this.getDropTablesValue(ddlGenerate, ddlMode);
        if (this.debug) {
            logger.fine("ejb.PersistenceProcessor.createanddroptables", new Object[]{new Boolean(createTables), new Boolean(dropTables)});
        }
        if (!createTables && !dropTables) {
            return;
        }
        this.constructJdbcFileNames(bundle);
        if (this.debug) {
            logger.fine("ejb.PersistenceProcessor.createanddropfilenames", this.createJdbcFileName, this.dropJdbcFileName);
        }
        this.dropTablesFromDB(dropTables, bundle);
        this.createTablesInDB(createTables, bundle, ddlMode);
    }

    protected boolean getCreateTablesValue(String ddlGenerate, String ddlMode) {
        boolean createTables = this.create && (this.cliCreateTables.equals("true") || (ddlGenerate.equals("create-tables") || ddlGenerate.equals("drop-and-create-tables")) && !ddlMode.equals("none") && this.cliCreateTables.equals("undefined"));
        return createTables;
    }

    protected boolean getDropTablesValue(String ddlGenerate, String ddlMode) {
        boolean dropTables = !this.create && (this.cliDropAndCreateTables.equals("true") || this.cliDropTables.equals("true") || ddlGenerate.equals("drop-and-create-tables") && (ddlMode.equals("database") || ddlMode.equals("both")) && this.cliDropAndCreateTables.equals("undefined") && this.cliDropTables.equals("undefined"));
        return dropTables;
    }

    private void constructJdbcFileNames(PersistenceUnitDescriptor parBundle) {
        this.createJdbcFileName = this.getPersistencePropVal(parBundle, "toplink.create-ddl-jdbc-file-name", null);
        this.dropJdbcFileName = this.getPersistencePropVal(parBundle, "toplink.drop-ddl-jdbc-file-name", null);
        if (null != this.createJdbcFileName && null != this.dropJdbcFileName) {
            return;
        }
        String filePrefix = EJBHelper.getDDLNamePrefix(parBundle.getParent().getParent());
        if (null == this.createJdbcFileName) {
            this.createJdbcFileName = filePrefix + '_' + parBundle.getName() + "_createDDL.jdbc";
        }
        if (null == this.dropJdbcFileName) {
            this.dropJdbcFileName = filePrefix + '_' + parBundle.getName() + "_dropDDL.jdbc";
        }
    }

    private void dropTablesFromDB(boolean dropTables, PersistenceUnitDescriptor bundle) {
        if (dropTables) {
            File dropFile = this.getDDLFile(bundle, this.dropJdbcFileName, false);
            if (dropFile.exists()) {
                Java2DBPersistenceUnitInfoImpl pi = new Java2DBPersistenceUnitInfoImpl(bundle, this.appDeployedLocation, null);
                this.executeDDLStatement(dropFile, pi.getNonJtaDataSource());
            } else if (this.isSupportedPersistenceProvider(bundle)) {
                this.logI18NWarnMessage("ejb.BaseProcessor.cannotdroptables", this.appRegisteredName, dropFile.getName(), null);
            }
        }
    }

    private void createTablesInDB(boolean createTables, PersistenceUnitDescriptor bundle, String ddlMode) {
        if (createTables) {
            this.pi = this.loadPersistenceUnitBundle(bundle, this.createJdbcFileName, this.dropJdbcFileName);
            if (null != this.pi && this.isDDLExecution(ddlMode)) {
                File createFile = this.getDDLFile(bundle, this.createJdbcFileName, true);
                if (createFile.exists()) {
                    this.executeDDLStatement(createFile, this.pi.getNonJtaDataSource());
                } else {
                    this.logI18NWarnMessage("ejb.BaseProcessor.cannotcreatetables", this.appRegisteredName, createFile.getName(), null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeDDLStatement(File fileName, DataSource nonJtaDataSource) {
        boolean result = false;
        Connection conn = null;
        Statement sql = null;
        try {
            try {
                conn = nonJtaDataSource.getConnection();
                sql = conn.createStatement();
                result = true;
            }
            catch (SQLException ex) {
                this.logI18NWarnMessage("ejb.BaseProcessor.cannotConnect", this.appRegisteredName, null, ex);
            }
            if (result) {
                this.executeDDLs(fileName, sql);
            }
        }
        catch (IOException e) {
            this.fileIOError(this.application.getRegistrationName(), e);
        }
        finally {
            PersistenceProcessor.closeConn(conn);
        }
        return result;
    }

    private void addPropertiesToPU(PersistenceUnitDescriptor puDescriptor) {
        this.addPropertyToDescriptor(puDescriptor, "toplink.target-server", "oracle.toplink.essentials.platform.server.sunas.SunAS9ServerPlatform");
        this.addPropertyToDescriptor(puDescriptor, "toplink.application-location", this.appGeneratedLocation);
        this.addPropertyToDescriptor(puDescriptor, "toplink.create-ddl-jdbc-file-name", this.createJdbcFileName);
        this.addPropertyToDescriptor(puDescriptor, "toplink.drop-ddl-jdbc-file-name", this.dropJdbcFileName);
    }

    private void addPropertyToDescriptor(PersistenceUnitDescriptor descriptor, String propertyName, String propertyValue) {
        String oldPropertyValue = descriptor.getProperties().getProperty(propertyName);
        if (null == oldPropertyValue) {
            descriptor.addProperty(propertyName, (Object)propertyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceUnitInfo loadPersistenceUnitBundle(PersistenceUnitDescriptor persistenceUnitDescriptor, String createJdbcFileName, String dropJdbcFileName) {
        logger.entering("loadPersistenceUnitBundle", "load", new Object[]{persistenceUnitDescriptor});
        if (!this.isSupportedPersistenceProvider(persistenceUnitDescriptor)) {
            if (this.cliCreateTables.equals("true") || this.cliDropAndCreateTables.equals("true")) {
                this.logI18NWarnMessage("ejb.PersistenceProcessor.nondefaultprovider", this.getProviderClassName(persistenceUnitDescriptor), persistenceUnitDescriptor.getName(), null);
            }
            return null;
        }
        this.addPropertiesToPU(persistenceUnitDescriptor);
        HashMap<String, String> overrides = new HashMap<String, String>();
        overrides.put("toplink.ddl-generation", "drop-and-create-tables");
        overrides.put("toplink.weaving", "FALSE");
        overrides.put("toplink.ddl-generation.output-mode", "sql-script");
        InstrumentableClassLoader cl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(persistenceUnitDescriptor.getClassLoader());
        Java2DBPersistenceUnitInfoImpl pi = new Java2DBPersistenceUnitInfoImpl(persistenceUnitDescriptor, this.appDeployedLocation, cl);
        if (this.debug) {
            logger.fine("PersistenceInfo for PU is :\n" + (Object)((Object)pi));
        }
        EntityManagerFactoryProvider provider = new EntityManagerFactoryProvider();
        EntityManagerFactory emf = null;
        try {
            emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)pi, overrides);
            emf.createEntityManager();
            if (this.debug) {
                logger.fine("PersistenceProcessor", "loadPersistenceUnitBundle", "emf = {0}", emf);
            }
        }
        finally {
            if (emf != null) {
                emf.close();
            }
        }
        return pi;
    }

    private String getPersistencePropVal(PersistenceUnitDescriptor parBundle, String propertyName, String defaultValue) {
        String propertyValue = null == defaultValue ? parBundle.getProperties().getProperty(propertyName) : parBundle.getProperties().getProperty(propertyName, defaultValue);
        return propertyValue;
    }

    private boolean isSupportedPersistenceProvider(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        String providerClassName = this.getProviderClassName(persistenceUnitDescriptor);
        return providerClassName.equals(TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_OLD) || providerClassName.equals(TOPLINK_PERSISTENCE_PROVIDER_CLASS_NAME_NEW);
    }

    private File getDDLFile(PersistenceUnitDescriptor bundle, String fileName, boolean create) {
        String appLocation = this.getPersistencePropVal(bundle, "toplink.application-location", this.appGeneratedLocation);
        return this.getDDLFile(appLocation + File.separator + fileName, create);
    }

    private String getProviderClassName(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        return PersistenceUnitInfoImpl.getPersistenceProviderClassNameForPuDesc((PersistenceUnitDescriptor)persistenceUnitDescriptor);
    }

    private boolean isDDLExecution(String ddlMode) {
        boolean rs = true;
        if (this.cliCreateTables.equals("undefined")) {
            rs = !ddlMode.equals("sql-script");
        }
        return rs;
    }

    class Java2DBPersistenceUnitInfoImpl
    extends PersistenceUnitInfoImpl {
        public Java2DBPersistenceUnitInfoImpl(PersistenceUnitDescriptor persistenceUnitDescriptor, String applicationLocation, InstrumentableClassLoader classLoader) {
            super(persistenceUnitDescriptor, applicationLocation, classLoader);
        }

        protected DataSource lookupPMDataSource(String DSName) throws NamingException {
            return (DataSource)ConnectorRuntime.getRuntime().lookupPMResource(DSName, true);
        }

        protected DataSource lookupNonJtaDataSource(String DSName) throws NamingException {
            return (DataSource)ConnectorRuntime.getRuntime().lookupNonTxResource(DSName, true);
        }
    }
}

