/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.OptimisticLockException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DoesExistQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;

public class WriteObjectQuery
extends ObjectLevelModifyQuery {
    public WriteObjectQuery() {
    }

    public WriteObjectQuery(Object objectToWrite) {
        this();
        this.setObject(objectToWrite);
    }

    public WriteObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    protected boolean doesObjectExist() {
        boolean doesExist;
        if (this.getSession().isUnitOfWork()) {
            boolean bl = doesExist = !((UnitOfWorkImpl)this.getSession()).isCloneNewObject(this.getObject());
            if (doesExist) {
                doesExist = ((UnitOfWorkImpl)this.getSession()).isObjectRegistered(this.getObject());
            }
        } else {
            DoesExistQuery existQuery = (DoesExistQuery)this.getDescriptor().getQueryManager().getDoesExistQuery().clone();
            existQuery.setObject(this.getObject());
            existQuery.setPrimaryKey(this.getPrimaryKey());
            existQuery.setDescriptor(this.getDescriptor());
            existQuery.setTranslationRow(this.getTranslationRow());
            doesExist = (Boolean)this.getSession().executeQuery(existQuery);
        }
        return doesExist;
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        if (this.getObjectChangeSet() != null) {
            return this.getQueryMechanism().executeWriteWithChangeSet();
        }
        return this.getQueryMechanism().executeWrite();
    }

    public void executeCommit() throws DatabaseException, OptimisticLockException {
        boolean doesExist = this.doesObjectExist();
        boolean shouldBeDeleted = this.shouldObjectBeDeleted();
        if (doesExist) {
            if (shouldBeDeleted) {
                this.getQueryMechanism().deleteObjectForWrite();
            } else {
                this.getQueryMechanism().updateObjectForWrite();
            }
        } else if (!shouldBeDeleted) {
            this.getQueryMechanism().insertObjectForWrite();
        }
    }

    public void executeCommitWithChangeSet() throws DatabaseException, OptimisticLockException {
        if (!this.getObjectChangeSet().isNew()) {
            if (!this.getSession().getCommitManager().isCommitInPreModify(this.objectChangeSet)) {
                this.getQueryMechanism().updateObjectForWriteWithChangeSet();
            }
        } else if (this.getSession().getCommitManager().isCommitInPreModify(this.objectChangeSet)) {
            this.dontCascadeParts();
            this.getQueryMechanism().insertObjectForWriteWithChangeSet();
            this.getSession().getCommitManager().markShallowCommit(this.object);
        } else {
            this.getQueryMechanism().insertObjectForWriteWithChangeSet();
        }
    }

    public void executeShallowWrite() {
        boolean doesExist = this.doesObjectExist();
        if (doesExist) {
            this.getQueryMechanism().shallowDeleteObjectForWrite(this.getObject(), this, this.getSession().getCommitManager());
        } else {
            this.getQueryMechanism().shallowInsertObjectForWrite(this.getObject(), this, this.getSession().getCommitManager());
        }
    }

    public boolean isWriteObjectQuery() {
        return true;
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.getTranslationRow() == null || this.getTranslationRow().isEmpty()) {
            this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getObject(), this.getSession()));
        }
    }

    public boolean shouldDependentObjectBeDeleted(Object object) {
        boolean shouldBeDeleted = this.getSession().isUnitOfWork() ? ((UnitOfWorkImpl)this.getSession()).isObjectDeleted(object) : true;
        return shouldBeDeleted;
    }

    protected boolean shouldObjectBeDeleted() {
        boolean shouldBeDeleted = this.getSession().isUnitOfWork() ? ((UnitOfWorkImpl)this.getSession()).isObjectDeleted(this.getObject()) : false;
        return shouldBeDeleted;
    }
}

