/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.FlowControlEntry;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import java.io.PrintStream;
import java.util.Hashtable;

class ConnectionFlowControlEntry
extends FlowControlEntry {
    protected boolean enableFlowControlCheck;
    protected int inQueueCounter = 0;
    protected int TEST_peakCount = 0;
    protected int TEST_pauseCount = 0;
    protected int TEST_resumeCount = 0;
    protected int flowControlChunkSize;
    protected int flowControlWaterMark;
    protected boolean resumeRequested = false;

    public ConnectionFlowControlEntry(FlowControl flowControl, ProtocolHandler protocolHandler, boolean bl, int n, int n2) {
        super(flowControl, protocolHandler);
        this.enableFlowControlCheck = bl;
        this.flowControlChunkSize = n;
        this.flowControlWaterMark = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived() {
        ConnectionFlowControlEntry connectionFlowControlEntry = this;
        synchronized (connectionFlowControlEntry) {
            ++this.inQueueCounter;
            if (this.inQueueCounter > this.TEST_peakCount) {
                this.TEST_peakCount = this.inQueueCounter;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageDelivered() {
        ConnectionFlowControlEntry connectionFlowControlEntry = this;
        synchronized (connectionFlowControlEntry) {
            --this.inQueueCounter;
            if (this.enableFlowControlCheck) {
                this.checkAndResumeFlow();
            }
        }
    }

    public void resetFlowControl(int n) {
        this.inQueueCounter -= n;
        if (this.inQueueCounter < 0) {
            this.inQueueCounter = 0;
        }
        if (this.enableFlowControlCheck) {
            this.checkAndResumeFlow();
        }
    }

    public synchronized void setResumeRequested(boolean bl) {
        if (this.debug) {
            Debug.println("setResumeRequsted[" + this + "] : " + bl);
        }
        this.resumeRequested = bl;
        if (bl) {
            ++this.TEST_pauseCount;
            this.checkAndResumeFlow();
        }
    }

    protected synchronized void sendResumeFlow() throws Exception {
        this.setResumeRequested(false);
        this.protocolHandler.resumeFlow(this.flowControlChunkSize);
        this.fc.removeFromReadyQueue(this);
        ++this.TEST_resumeCount;
    }

    private synchronized void checkAndResumeFlow() {
        if (this.resumeRequested && (!this.enableFlowControlCheck || this.inQueueCounter < this.flowControlWaterMark)) {
            this.fc.addToReadyQueue(this);
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("enableFlowControlCheck", String.valueOf(this.enableFlowControlCheck));
        hashtable.put("inQueueCounter", String.valueOf(this.inQueueCounter));
        hashtable.put("peakCount", String.valueOf(this.TEST_peakCount));
        hashtable.put("isFlowPaused", String.valueOf(this.resumeRequested));
        hashtable.put("pauseCount", String.valueOf(this.TEST_pauseCount));
        hashtable.put("resumeCount", String.valueOf(this.TEST_resumeCount));
        return hashtable;
    }

    protected Object TEST_GetAttribute(String string) {
        if (string.equals("FlowControl.Count")) {
            return new Integer(this.inQueueCounter);
        }
        if (string.equals("FlowControl.PeakCount")) {
            return new Integer(this.TEST_peakCount);
        }
        if (string.equals("FlowControl.IsFlowPaused")) {
            return this.resumeRequested;
        }
        if (string.equals("FlowControl.PauseCount")) {
            return new Integer(this.TEST_pauseCount);
        }
        return null;
    }

    protected void status_report(PrintStream printStream) {
        printStream.println("FlowControlState for Connection : " + this.fc.connection);
        printStream.println("\t# pending messages : " + this.inQueueCounter);
        printStream.println("\t# resumeRequested : " + this.resumeRequested);
        printStream.println("\t# flowControlWaterMark : " + this.flowControlWaterMark);
    }

    public String toString() {
        return "ConnectionFlowControlEntry[" + this.fc.connection + "]";
    }
}

