/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jms.IllegalStateException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;

public class ConnectionRecover
implements Runnable {
    protected ConnectionImpl connection = null;
    protected static final String iMQConnectionRecover = "iMQConnectionRecover-";
    private boolean debug = Debug.debug;
    protected static final int RECOVER_INACTIVE = 0;
    protected static final int RECOVER_STOPPED = 1;
    protected static final int RECOVER_STARTED = 2;
    protected static final int RECOVER_IN_PROCESS = 3;
    protected static final int TRANSPORT_CONNECTED = 4;
    protected static final int RECOVER_SUCCEEDED = 5;
    protected static final int RECOVER_FAILED = 6;
    protected static final int RECOVER_ABORTED = 7;
    protected static final String[] STATES = new String[]{"RECOVER_INACTIVE", "RECOVER_STOPPED", "RECOVER_STARTED", "RECOVER_IN_PROCESS", "RECOVER_TRANSPORT_CONNECTED", "RECOVER_SUCCEEDED", "RECOVER_FAILED", "RECOVER_ABORTED"};
    private int recoverState = 0;
    private int maxRetries = 100;
    private int failedCount = 0;
    protected Thread recoverThread = null;
    private static final int WAIT_TIME = 3000;
    private static final int MAX_WAIT_COUNT = 200;
    public int recoverDelay = 3000;
    private Logger connLogger = ConnectionImpl.connectionLogger;

    public ConnectionRecover(ConnectionImpl connectionImpl) {
        this.connection = connectionImpl;
        String string = connectionImpl.getTrimmedProperty("imq.recover.maxRetries");
        if (string != null) {
            this.maxRetries = Integer.parseInt(string);
        }
        if ((string = connectionImpl.getTrimmedProperty("imq.recover.delay")) != null) {
            this.recoverDelay = Integer.parseInt(string);
            if (connectionImpl.isConnectedToHABroker && this.recoverDelay < 3000) {
                this.recoverDelay = 3000;
            }
        }
        this.logRecoverState(0);
    }

    protected void init() throws JMSException {
        Debug.println("*** in ConnectionRecover.init() ...");
        if (this.connection.isConnectedToHABroker) {
            if (this.recoverDelay < 3000) {
                this.recoverDelay = 3000;
            }
            this.sleep(this.recoverDelay);
        }
        this.closeProtocolHandler();
        this.connection.protocolHandler.init(true);
        this.logRecoverState(4);
    }

    public void start() {
        this.recoverThread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            this.recoverThread.setDaemon(true);
        }
        this.recoverThread.setName("iMQConnectionRecover--" + this.connection.getLocalID() + "-" + this.connection.getConnectionID());
        this.setRecoverState(2);
        this.recoverThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.connection.protocolHandler.recoverThread = Thread.currentThread();
        try {
            this.setRecoverState(3);
            this.recover();
            this.setRecoverState(5);
            this.failedCount = 0;
        }
        catch (JMSException jMSException) {
            this.setRecoverState(6);
            this.connLogger.log(Level.WARNING, jMSException.toString(), jMSException);
            this.connection.triggerConnectionReconnectFailedEvent(jMSException);
            this.checkForMaxRetries();
            this.closeProtocolHandler();
        }
        finally {
            if (this.recoverState == 5) {
                this.connection.triggerConnectionReconnectedEvent();
            }
            this.connection.protocolHandler.recoverThread = null;
            this.setRecoverState(0);
        }
    }

    protected void recover() throws JMSException {
        try {
            if (this.debug) {
                Debug.println("BEGIN ConnectionRecover.recover()...");
            }
            if (this.connection.isCloseCalled) {
                this.connection.setReconnecting(false);
                return;
            }
            this.checkConnectionConsumers();
            this.resetSessions();
            this.connection.hello(true);
            this.connection.protocolHandler.resetClientID();
            this.addSessions();
            this.addConsumers();
            this.addProducers();
            if (!this.connection.isStopped && this.connection.eventListener == null) {
                this.connection.protocolHandler.start();
            }
            if (this.debug) {
                Debug.info("ConnectionRecover.recover() SUCCESS!!!");
            }
        }
        catch (JMSException jMSException) {
            if (this.debug) {
                Debug.println("ConnectionRecover failed.");
                Debug.printStackTrace((Exception)((Object)jMSException));
            }
            throw jMSException;
        }
        finally {
            if (this.debug) {
                Debug.println("END ConnectionRecover.recover()!!!");
            }
        }
    }

    protected void checkConnectionConsumers() throws JMSException {
        if (this.connection.connectionConsumerTable.size() > 0) {
            String string = AdministeredObject.cr.getKString("C4061");
            IllegalStateException illegalStateException = new IllegalStateException(string, "C4061");
            ExceptionHandler.throwJMSException((JMSException)((Object)illegalStateException));
        }
    }

    protected void resetSessions() throws JMSException {
        Enumeration enumeration = this.connection.sessionTable.elements();
        while (enumeration.hasMoreElements()) {
            SessionImpl sessionImpl = (SessionImpl)enumeration.nextElement();
            if (sessionImpl.getMessageListener() != null) {
                String string = AdministeredObject.cr.getKString("C4061");
                IllegalStateException illegalStateException = new IllegalStateException(string, "C4061");
                ExceptionHandler.throwJMSException((JMSException)((Object)illegalStateException));
            }
            sessionImpl.reset();
        }
    }

    protected void addSessions() throws JMSException {
        Enumeration enumeration = this.connection.sessionTable.elements();
        while (enumeration.hasMoreElements()) {
            SessionImpl sessionImpl = (SessionImpl)enumeration.nextElement();
            sessionImpl.recreateSession();
        }
    }

    protected void addConsumers() throws JMSException {
        Object[] objectArray = this.connection.interestTable.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.connection.protocolHandler.addInterest((Consumer)objectArray[i]);
        }
    }

    protected void addProducers() throws JMSException {
        Enumeration enumeration = this.connection.sessionTable.elements();
        while (enumeration.hasMoreElements()) {
            SessionImpl sessionImpl = (SessionImpl)enumeration.nextElement();
            this.addSessionProducers(sessionImpl);
        }
    }

    protected void addSessionProducers(SessionImpl sessionImpl) throws JMSException {
        Enumeration enumeration = sessionImpl.producers.elements();
        while (enumeration.hasMoreElements()) {
            MessageProducerImpl messageProducerImpl = (MessageProducerImpl)enumeration.nextElement();
            messageProducerImpl.recreateProducer();
        }
    }

    protected synchronized void setRecoverState(int n) {
        if (this.recoverState != 7) {
            this.recoverState = n;
            this.logRecoverState(n);
        } else {
            this.logRecoverState(7);
        }
        this.notifyAll();
    }

    protected synchronized int getRecoverState() {
        return this.recoverState;
    }

    private void closeProtocolHandler() {
        block2: {
            try {
                this.connection.protocolHandler.close();
            }
            catch (Exception exception) {
                if (!this.debug) break block2;
                Debug.printStackTrace(exception);
            }
        }
    }

    private void checkForMaxRetries() {
        ++this.failedCount;
        if (this.maxRetries == -1) {
            return;
        }
        if (this.failedCount > this.maxRetries) {
            this.setRecoverState(7);
            if (this.debug) {
                Debug.println("*** reached max internal retry count: " + this.maxRetries);
            }
            String string = AdministeredObject.cr.getKString("I113", this.connection.getBrokerAddressList(), this.maxRetries);
            this.connLogger.log(Level.SEVERE, string);
        }
    }

    public synchronized void waitUntilInactive() throws JMSException {
        Object object;
        int n = 0;
        int n2 = 0;
        if (this.recoverState == 7) {
            object = new JMSException("ConnectionRecover aborted!");
            ExceptionHandler.throwJMSException(object);
        }
        while (this.recoverState != 0 && this.recoverState != 7) {
            try {
                this.wait(3000L);
                if (++n2 == 5) {
                    object = AdministeredObject.cr.getKString("I107", STATES[this.getRecoverState()], this.connection.getLastContactedBrokerAddress());
                    this.connLogger.log(Level.INFO, (String)object);
                    n2 = 0;
                }
            }
            catch (Exception exception) {
                this.connLogger.log(Level.WARNING, exception.toString(), exception);
            }
            if (this.connection.isCloseCalled) {
                this.setRecoverState(7);
                return;
            }
            this.connection.readChannel.closeIOAndNotify();
            if (++n <= 200) continue;
            this.setRecoverState(7);
            object = new JMSException("Timeout on ConnectionRecover object.  Broker: " + this.connection.getLastContactedBrokerAddress());
            ExceptionHandler.throwJMSException(object);
        }
    }

    private void sleep(int n) {
        try {
            int n2 = n / 3000;
            for (int i = 0; i < n2; ++i) {
                if (this.debug) {
                    Debug.println("*** ConnectionRecover, sleeping " + 3000 * (i + 1) + " milli secs");
                }
                Thread.sleep(3000L);
                if (!this.connection.isCloseCalled) continue;
                return;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logRecoverState(int n) {
        if (this.connLogger.isLoggable(Level.INFO)) {
            String string = this.connection.getLastContactedBrokerAddress();
            String string2 = AdministeredObject.cr.getKString("I107", STATES[n], string);
            this.connLogger.log(Level.INFO, string2);
        }
    }
}

