/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.transport.httptunnel;

import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelConnection;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelInputStream;
import com.sun.messaging.jmq.transport.httptunnel.HttpTunnelOutputStream;
import com.sun.messaging.jmq.transport.httptunnel.client.HttpTunnelClientDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public class HttpTunnelSocket {
    private HttpTunnelConnection conn = null;
    private InputStream is = null;
    private OutputStream os = null;
    private boolean sockClosed = false;

    public HttpTunnelSocket(String string) throws IOException {
        HttpTunnelClientDriver httpTunnelClientDriver = new HttpTunnelClientDriver(string);
        this.conn = httpTunnelClientDriver.doConnect();
        this.initSocket();
    }

    protected HttpTunnelSocket(HttpTunnelConnection httpTunnelConnection) {
        this.conn = httpTunnelConnection;
        this.initSocket();
    }

    protected void initSocket() {
        this.is = null;
        this.os = null;
        this.sockClosed = false;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.sockClosed) {
            throw new IOException("Socket closed");
        }
        if (this.is == null) {
            this.is = new HttpTunnelInputStream(this.conn);
        }
        return this.is;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.sockClosed) {
            throw new IOException("Socket closed");
        }
        if (this.os == null) {
            this.os = new HttpTunnelOutputStream(this.conn);
        }
        return this.os;
    }

    public synchronized void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        if (this.os != null) {
            this.os.close();
        }
        this.sockClosed = true;
        this.conn.closeConn();
    }

    public int getConnId() {
        return this.conn.getConnId();
    }

    public int getPullPeriod() {
        return this.conn.getPullPeriod();
    }

    public void setPullPeriod(int n) throws IOException {
        this.conn.setPullPeriod(n);
    }

    public int getConnectionTimeout() {
        return this.conn.getConnectionTimeout();
    }

    public void setConnectionTimeout(int n) throws IOException {
        this.conn.setConnectionTimeout(n);
    }

    public Hashtable getDebugState() {
        return this.conn.getDebugState();
    }
}

